<?php

namespace Eurostop\Sales;

class SubmitReceipts
{

    /**
     * @var ArrayOfSubmittedReceiptHeader $receipts
     */
    protected $receipts = null;

    /**
     * @var string $submissionReference
     */
    protected $submissionReference = null;

    /**
     * @param ArrayOfSubmittedReceiptHeader $receipts
     * @param string $submissionReference
     */
    public function __construct($receipts, $submissionReference)
    {
      $this->receipts = $receipts;
      $this->submissionReference = $submissionReference;
    }

    /**
     * @return ArrayOfSubmittedReceiptHeader
     */
    public function getReceipts()
    {
      return $this->receipts;
    }

    /**
     * @param ArrayOfSubmittedReceiptHeader $receipts
     * @return \Eurostop\Sales\SubmitReceipts
     */
    public function setReceipts($receipts)
    {
      $this->receipts = $receipts;
      return $this;
    }

    /**
     * @return string
     */
    public function getSubmissionReference()
    {
      return $this->submissionReference;
    }

    /**
     * @param string $submissionReference
     * @return \Eurostop\Sales\SubmitReceipts
     */
    public function setSubmissionReference($submissionReference)
    {
      $this->submissionReference = $submissionReference;
      return $this;
    }

}
