<?php

namespace Eurostop\Sales;

class ReceiptTender extends RetrievedDataItemOfReceiptTenderDtonkuuQA70
{

    /**
     * @var string $AuthCode
     */
    protected $AuthCode = null;

    /**
     * @var string $CardExpiry
     */
    protected $CardExpiry = null;

    /**
     * @var string $CardIssueNumber
     */
    protected $CardIssueNumber = null;

    /**
     * @var string $CardNumber
     */
    protected $CardNumber = null;

    /**
     * @var string $CardStartDate
     */
    protected $CardStartDate = null;

    /**
     * @var string $CurrencyIdentifier
     */
    protected $CurrencyIdentifier = null;

    /**
     * @var float $CurrencyValue
     */
    protected $CurrencyValue = null;

    /**
     * @var boolean $IsChange
     */
    protected $IsChange = null;

    /**
     * @var int $ItemNumber
     */
    protected $ItemNumber = null;

    /**
     * @var string $TenderReceiptNumber
     */
    protected $TenderReceiptNumber = null;

    /**
     * @var TenderTypeClass $TypeClass
     */
    protected $TypeClass = null;

    /**
     * @var string $TypeCode
     */
    protected $TypeCode = null;

    /**
     * @var string $TypeDescription
     */
    protected $TypeDescription = null;

    /**
     * @var string $TypeSubCode
     */
    protected $TypeSubCode = null;

    /**
     * @var float $Value
     */
    protected $Value = null;

    /**
     * @param boolean $IsChange
     * @param int $ItemNumber
     * @param TenderTypeClass $TypeClass
     * @param float $Value
     */
    public function __construct($IsChange, $ItemNumber, $TypeClass, $Value)
    {
      parent::__construct();
      $this->IsChange = $IsChange;
      $this->ItemNumber = $ItemNumber;
      $this->TypeClass = $TypeClass;
      $this->Value = $Value;
    }

    /**
     * @return string
     */
    public function getAuthCode()
    {
      return $this->AuthCode;
    }

    /**
     * @param string $AuthCode
     * @return \Eurostop\Sales\ReceiptTender
     */
    public function setAuthCode($AuthCode)
    {
      $this->AuthCode = $AuthCode;
      return $this;
    }

    /**
     * @return string
     */
    public function getCardExpiry()
    {
      return $this->CardExpiry;
    }

    /**
     * @param string $CardExpiry
     * @return \Eurostop\Sales\ReceiptTender
     */
    public function setCardExpiry($CardExpiry)
    {
      $this->CardExpiry = $CardExpiry;
      return $this;
    }

    /**
     * @return string
     */
    public function getCardIssueNumber()
    {
      return $this->CardIssueNumber;
    }

    /**
     * @param string $CardIssueNumber
     * @return \Eurostop\Sales\ReceiptTender
     */
    public function setCardIssueNumber($CardIssueNumber)
    {
      $this->CardIssueNumber = $CardIssueNumber;
      return $this;
    }

    /**
     * @return string
     */
    public function getCardNumber()
    {
      return $this->CardNumber;
    }

    /**
     * @param string $CardNumber
     * @return \Eurostop\Sales\ReceiptTender
     */
    public function setCardNumber($CardNumber)
    {
      $this->CardNumber = $CardNumber;
      return $this;
    }

    /**
     * @return string
     */
    public function getCardStartDate()
    {
      return $this->CardStartDate;
    }

    /**
     * @param string $CardStartDate
     * @return \Eurostop\Sales\ReceiptTender
     */
    public function setCardStartDate($CardStartDate)
    {
      $this->CardStartDate = $CardStartDate;
      return $this;
    }

    /**
     * @return string
     */
    public function getCurrencyIdentifier()
    {
      return $this->CurrencyIdentifier;
    }

    /**
     * @param string $CurrencyIdentifier
     * @return \Eurostop\Sales\ReceiptTender
     */
    public function setCurrencyIdentifier($CurrencyIdentifier)
    {
      $this->CurrencyIdentifier = $CurrencyIdentifier;
      return $this;
    }

    /**
     * @return float
     */
    public function getCurrencyValue()
    {
      return $this->CurrencyValue;
    }

    /**
     * @param float $CurrencyValue
     * @return \Eurostop\Sales\ReceiptTender
     */
    public function setCurrencyValue($CurrencyValue)
    {
      $this->CurrencyValue = $CurrencyValue;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getIsChange()
    {
      return $this->IsChange;
    }

    /**
     * @param boolean $IsChange
     * @return \Eurostop\Sales\ReceiptTender
     */
    public function setIsChange($IsChange)
    {
      $this->IsChange = $IsChange;
      return $this;
    }

    /**
     * @return int
     */
    public function getItemNumber()
    {
      return $this->ItemNumber;
    }

    /**
     * @param int $ItemNumber
     * @return \Eurostop\Sales\ReceiptTender
     */
    public function setItemNumber($ItemNumber)
    {
      $this->ItemNumber = $ItemNumber;
      return $this;
    }

    /**
     * @return string
     */
    public function getTenderReceiptNumber()
    {
      return $this->TenderReceiptNumber;
    }

    /**
     * @param string $TenderReceiptNumber
     * @return \Eurostop\Sales\ReceiptTender
     */
    public function setTenderReceiptNumber($TenderReceiptNumber)
    {
      $this->TenderReceiptNumber = $TenderReceiptNumber;
      return $this;
    }

    /**
     * @return TenderTypeClass
     */
    public function getTypeClass()
    {
      return $this->TypeClass;
    }

    /**
     * @param TenderTypeClass $TypeClass
     * @return \Eurostop\Sales\ReceiptTender
     */
    public function setTypeClass($TypeClass)
    {
      $this->TypeClass = $TypeClass;
      return $this;
    }

    /**
     * @return string
     */
    public function getTypeCode()
    {
      return $this->TypeCode;
    }

    /**
     * @param string $TypeCode
     * @return \Eurostop\Sales\ReceiptTender
     */
    public function setTypeCode($TypeCode)
    {
      $this->TypeCode = $TypeCode;
      return $this;
    }

    /**
     * @return string
     */
    public function getTypeDescription()
    {
      return $this->TypeDescription;
    }

    /**
     * @param string $TypeDescription
     * @return \Eurostop\Sales\ReceiptTender
     */
    public function setTypeDescription($TypeDescription)
    {
      $this->TypeDescription = $TypeDescription;
      return $this;
    }

    /**
     * @return string
     */
    public function getTypeSubCode()
    {
      return $this->TypeSubCode;
    }

    /**
     * @param string $TypeSubCode
     * @return \Eurostop\Sales\ReceiptTender
     */
    public function setTypeSubCode($TypeSubCode)
    {
      $this->TypeSubCode = $TypeSubCode;
      return $this;
    }

    /**
     * @return float
     */
    public function getValue()
    {
      return $this->Value;
    }

    /**
     * @param float $Value
     * @return \Eurostop\Sales\ReceiptTender
     */
    public function setValue($Value)
    {
      $this->Value = $Value;
      return $this;
    }

}
