<?php

namespace Eurostop\Sales;

class ArrayOfReceiptTaxCollection implements \ArrayAccess, \Iterator, \Countable
{

    /**
     * @var ReceiptTaxCollection[] $ReceiptTaxCollection
     */
    protected $ReceiptTaxCollection = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return ReceiptTaxCollection[]
     */
    public function getReceiptTaxCollection()
    {
      return $this->ReceiptTaxCollection;
    }

    /**
     * @param ReceiptTaxCollection[] $ReceiptTaxCollection
     * @return \Eurostop\Sales\ArrayOfReceiptTaxCollection
     */
    public function setReceiptTaxCollection(array $ReceiptTaxCollection = null)
    {
      $this->ReceiptTaxCollection = $ReceiptTaxCollection;
      return $this;
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset An offset to check for
     * @return boolean true on success or false on failure
     */
    public function offsetExists($offset)
    {
      return isset($this->ReceiptTaxCollection[$offset]);
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to retrieve
     * @return ReceiptTaxCollection
     */
    public function offsetGet($offset)
    {
      return $this->ReceiptTaxCollection[$offset];
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to assign the value to
     * @param ReceiptTaxCollection $value The value to set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
      if (!isset($offset)) {
        $this->ReceiptTaxCollection[] = $value;
      } else {
        $this->ReceiptTaxCollection[$offset] = $value;
      }
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to unset
     * @return void
     */
    public function offsetUnset($offset)
    {
      unset($this->ReceiptTaxCollection[$offset]);
    }

    /**
     * Iterator implementation
     *
     * @return ReceiptTaxCollection Return the current element
     */
    public function current()
    {
      return current($this->ReceiptTaxCollection);
    }

    /**
     * Iterator implementation
     * Move forward to next element
     *
     * @return void
     */
    public function next()
    {
      next($this->ReceiptTaxCollection);
    }

    /**
     * Iterator implementation
     *
     * @return string|null Return the key of the current element or null
     */
    public function key()
    {
      return key($this->ReceiptTaxCollection);
    }

    /**
     * Iterator implementation
     *
     * @return boolean Return the validity of the current position
     */
    public function valid()
    {
      return $this->key() !== null;
    }

    /**
     * Iterator implementation
     * Rewind the Iterator to the first element
     *
     * @return void
     */
    public function rewind()
    {
      reset($this->ReceiptTaxCollection);
    }

    /**
     * Countable implementation
     *
     * @return ReceiptTaxCollection Return count of elements
     */
    public function count()
    {
      return count($this->ReceiptTaxCollection);
    }

}
