<?php

namespace Eurostop\Sales;

class ArrayOfReceiptHeader implements \ArrayAccess, \Iterator, \Countable
{

    /**
     * @var ReceiptHeader[] $ReceiptHeader
     */
    protected $ReceiptHeader = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return ReceiptHeader[]
     */
    public function getReceiptHeader()
    {
      return $this->ReceiptHeader;
    }

    /**
     * @param ReceiptHeader[] $ReceiptHeader
     * @return \Eurostop\Sales\ArrayOfReceiptHeader
     */
    public function setReceiptHeader(array $ReceiptHeader = null)
    {
      $this->ReceiptHeader = $ReceiptHeader;
      return $this;
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset An offset to check for
     * @return boolean true on success or false on failure
     */
    public function offsetExists($offset)
    {
      return isset($this->ReceiptHeader[$offset]);
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to retrieve
     * @return ReceiptHeader
     */
    public function offsetGet($offset)
    {
      return $this->ReceiptHeader[$offset];
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to assign the value to
     * @param ReceiptHeader $value The value to set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
      if (!isset($offset)) {
        $this->ReceiptHeader[] = $value;
      } else {
        $this->ReceiptHeader[$offset] = $value;
      }
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to unset
     * @return void
     */
    public function offsetUnset($offset)
    {
      unset($this->ReceiptHeader[$offset]);
    }

    /**
     * Iterator implementation
     *
     * @return ReceiptHeader Return the current element
     */
    public function current()
    {
      return current($this->ReceiptHeader);
    }

    /**
     * Iterator implementation
     * Move forward to next element
     *
     * @return void
     */
    public function next()
    {
      next($this->ReceiptHeader);
    }

    /**
     * Iterator implementation
     *
     * @return string|null Return the key of the current element or null
     */
    public function key()
    {
      return key($this->ReceiptHeader);
    }

    /**
     * Iterator implementation
     *
     * @return boolean Return the validity of the current position
     */
    public function valid()
    {
      return $this->key() !== null;
    }

    /**
     * Iterator implementation
     * Rewind the Iterator to the first element
     *
     * @return void
     */
    public function rewind()
    {
      reset($this->ReceiptHeader);
    }

    /**
     * Countable implementation
     *
     * @return ReceiptHeader Return count of elements
     */
    public function count()
    {
      return count($this->ReceiptHeader);
    }

}
