<?php

namespace Eurostop\Products;

class SubmitSkuAdditionalPrice
{

    /**
     * @var SubmittedSkuAdditionalPrice $skuAdditionalPrice
     */
    protected $skuAdditionalPrice = null;

    /**
     * @var string $submissionReference
     */
    protected $submissionReference = null;

    /**
     * @param SubmittedSkuAdditionalPrice $skuAdditionalPrice
     * @param string $submissionReference
     */
    public function __construct($skuAdditionalPrice, $submissionReference)
    {
      $this->skuAdditionalPrice = $skuAdditionalPrice;
      $this->submissionReference = $submissionReference;
    }

    /**
     * @return SubmittedSkuAdditionalPrice
     */
    public function getSkuAdditionalPrice()
    {
      return $this->skuAdditionalPrice;
    }

    /**
     * @param SubmittedSkuAdditionalPrice $skuAdditionalPrice
     * @return \Eurostop\Products\SubmitSkuAdditionalPrice
     */
    public function setSkuAdditionalPrice($skuAdditionalPrice)
    {
      $this->skuAdditionalPrice = $skuAdditionalPrice;
      return $this;
    }

    /**
     * @return string
     */
    public function getSubmissionReference()
    {
      return $this->submissionReference;
    }

    /**
     * @param string $submissionReference
     * @return \Eurostop\Products\SubmitSkuAdditionalPrice
     */
    public function setSubmissionReference($submissionReference)
    {
      $this->submissionReference = $submissionReference;
      return $this;
    }

}
