<?php

namespace Eurostop\Products;

class SubmitSkuActions
{

    /**
     * @var ArrayOfSubmittedSkuAction $skuActions
     */
    protected $skuActions = null;

    /**
     * @var string $submissionReference
     */
    protected $submissionReference = null;

    /**
     * @param ArrayOfSubmittedSkuAction $skuActions
     * @param string $submissionReference
     */
    public function __construct($skuActions, $submissionReference)
    {
      $this->skuActions = $skuActions;
      $this->submissionReference = $submissionReference;
    }

    /**
     * @return ArrayOfSubmittedSkuAction
     */
    public function getSkuActions()
    {
      return $this->skuActions;
    }

    /**
     * @param ArrayOfSubmittedSkuAction $skuActions
     * @return \Eurostop\Products\SubmitSkuActions
     */
    public function setSkuActions($skuActions)
    {
      $this->skuActions = $skuActions;
      return $this;
    }

    /**
     * @return string
     */
    public function getSubmissionReference()
    {
      return $this->submissionReference;
    }

    /**
     * @param string $submissionReference
     * @return \Eurostop\Products\SubmitSkuActions
     */
    public function setSubmissionReference($submissionReference)
    {
      $this->submissionReference = $submissionReference;
      return $this;
    }

}
