<?php

namespace Eurostop\Products;

class SubmitSizeGroups
{

    /**
     * @var ArrayOfSubmittedSizeGroup $sizeGroups
     */
    protected $sizeGroups = null;

    /**
     * @var string $submissionReference
     */
    protected $submissionReference = null;

    /**
     * @param ArrayOfSubmittedSizeGroup $sizeGroups
     * @param string $submissionReference
     */
    public function __construct($sizeGroups, $submissionReference)
    {
      $this->sizeGroups = $sizeGroups;
      $this->submissionReference = $submissionReference;
    }

    /**
     * @return ArrayOfSubmittedSizeGroup
     */
    public function getSizeGroups()
    {
      return $this->sizeGroups;
    }

    /**
     * @param ArrayOfSubmittedSizeGroup $sizeGroups
     * @return \Eurostop\Products\SubmitSizeGroups
     */
    public function setSizeGroups($sizeGroups)
    {
      $this->sizeGroups = $sizeGroups;
      return $this;
    }

    /**
     * @return string
     */
    public function getSubmissionReference()
    {
      return $this->submissionReference;
    }

    /**
     * @param string $submissionReference
     * @return \Eurostop\Products\SubmitSizeGroups
     */
    public function setSubmissionReference($submissionReference)
    {
      $this->submissionReference = $submissionReference;
      return $this;
    }

}
