<?php

namespace Eurostop\Products;

class SubmitColours
{

    /**
     * @var ArrayOfSubmittedColour $colours
     */
    protected $colours = null;

    /**
     * @var string $submissionReference
     */
    protected $submissionReference = null;

    /**
     * @param ArrayOfSubmittedColour $colours
     * @param string $submissionReference
     */
    public function __construct($colours, $submissionReference)
    {
      $this->colours = $colours;
      $this->submissionReference = $submissionReference;
    }

    /**
     * @return ArrayOfSubmittedColour
     */
    public function getColours()
    {
      return $this->colours;
    }

    /**
     * @param ArrayOfSubmittedColour $colours
     * @return \Eurostop\Products\SubmitColours
     */
    public function setColours($colours)
    {
      $this->colours = $colours;
      return $this;
    }

    /**
     * @return string
     */
    public function getSubmissionReference()
    {
      return $this->submissionReference;
    }

    /**
     * @param string $submissionReference
     * @return \Eurostop\Products\SubmitColours
     */
    public function setSubmissionReference($submissionReference)
    {
      $this->submissionReference = $submissionReference;
      return $this;
    }

}
