<?php

namespace Eurostop\Products;

class GetColour
{

    /**
     * @var string $colourIdentifier
     */
    protected $colourIdentifier = null;

    /**
     * @var ColourIdentifierType $colourIdentifierType
     */
    protected $colourIdentifierType = null;

    /**
     * @var string $seasonIdentifier
     */
    protected $seasonIdentifier = null;

    /**
     * @var HierarchyNodeIdentifierType $hierarchyNodeIdentifierType
     */
    protected $hierarchyNodeIdentifierType = null;

    /**
     * @var string $cultureCode
     */
    protected $cultureCode = null;

    /**
     * @param string $colourIdentifier
     * @param ColourIdentifierType $colourIdentifierType
     * @param string $seasonIdentifier
     * @param HierarchyNodeIdentifierType $hierarchyNodeIdentifierType
     * @param string $cultureCode
     */
    public function __construct($colourIdentifier, $colourIdentifierType, $seasonIdentifier, $hierarchyNodeIdentifierType, $cultureCode)
    {
      $this->colourIdentifier = $colourIdentifier;
      $this->colourIdentifierType = $colourIdentifierType;
      $this->seasonIdentifier = $seasonIdentifier;
      $this->hierarchyNodeIdentifierType = $hierarchyNodeIdentifierType;
      $this->cultureCode = $cultureCode;
    }

    /**
     * @return string
     */
    public function getColourIdentifier()
    {
      return $this->colourIdentifier;
    }

    /**
     * @param string $colourIdentifier
     * @return \Eurostop\Products\GetColour
     */
    public function setColourIdentifier($colourIdentifier)
    {
      $this->colourIdentifier = $colourIdentifier;
      return $this;
    }

    /**
     * @return ColourIdentifierType
     */
    public function getColourIdentifierType()
    {
      return $this->colourIdentifierType;
    }

    /**
     * @param ColourIdentifierType $colourIdentifierType
     * @return \Eurostop\Products\GetColour
     */
    public function setColourIdentifierType($colourIdentifierType)
    {
      $this->colourIdentifierType = $colourIdentifierType;
      return $this;
    }

    /**
     * @return string
     */
    public function getSeasonIdentifier()
    {
      return $this->seasonIdentifier;
    }

    /**
     * @param string $seasonIdentifier
     * @return \Eurostop\Products\GetColour
     */
    public function setSeasonIdentifier($seasonIdentifier)
    {
      $this->seasonIdentifier = $seasonIdentifier;
      return $this;
    }

    /**
     * @return HierarchyNodeIdentifierType
     */
    public function getHierarchyNodeIdentifierType()
    {
      return $this->hierarchyNodeIdentifierType;
    }

    /**
     * @param HierarchyNodeIdentifierType $hierarchyNodeIdentifierType
     * @return \Eurostop\Products\GetColour
     */
    public function setHierarchyNodeIdentifierType($hierarchyNodeIdentifierType)
    {
      $this->hierarchyNodeIdentifierType = $hierarchyNodeIdentifierType;
      return $this;
    }

    /**
     * @return string
     */
    public function getCultureCode()
    {
      return $this->cultureCode;
    }

    /**
     * @param string $cultureCode
     * @return \Eurostop\Products\GetColour
     */
    public function setCultureCode($cultureCode)
    {
      $this->cultureCode = $cultureCode;
      return $this;
    }

}
