<?php

namespace Eurostop\Products;

class ArrayOfHierarchyNode implements \ArrayAccess, \Iterator, \Countable
{

    /**
     * @var HierarchyNode[] $HierarchyNode
     */
    protected $HierarchyNode = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return HierarchyNode[]
     */
    public function getHierarchyNode()
    {
      return $this->HierarchyNode;
    }

    /**
     * @param HierarchyNode[] $HierarchyNode
     * @return \Eurostop\Products\ArrayOfHierarchyNode
     */
    public function setHierarchyNode(array $HierarchyNode = null)
    {
      $this->HierarchyNode = $HierarchyNode;
      return $this;
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset An offset to check for
     * @return boolean true on success or false on failure
     */
    public function offsetExists($offset)
    {
      return isset($this->HierarchyNode[$offset]);
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to retrieve
     * @return HierarchyNode
     */
    public function offsetGet($offset)
    {
      return $this->HierarchyNode[$offset];
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to assign the value to
     * @param HierarchyNode $value The value to set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
      if (!isset($offset)) {
        $this->HierarchyNode[] = $value;
      } else {
        $this->HierarchyNode[$offset] = $value;
      }
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to unset
     * @return void
     */
    public function offsetUnset($offset)
    {
      unset($this->HierarchyNode[$offset]);
    }

    /**
     * Iterator implementation
     *
     * @return HierarchyNode Return the current element
     */
    public function current()
    {
      return current($this->HierarchyNode);
    }

    /**
     * Iterator implementation
     * Move forward to next element
     *
     * @return void
     */
    public function next()
    {
      next($this->HierarchyNode);
    }

    /**
     * Iterator implementation
     *
     * @return string|null Return the key of the current element or null
     */
    public function key()
    {
      return key($this->HierarchyNode);
    }

    /**
     * Iterator implementation
     *
     * @return boolean Return the validity of the current position
     */
    public function valid()
    {
      return $this->key() !== null;
    }

    /**
     * Iterator implementation
     * Rewind the Iterator to the first element
     *
     * @return void
     */
    public function rewind()
    {
      reset($this->HierarchyNode);
    }

    /**
     * Countable implementation
     *
     * @return HierarchyNode Return count of elements
     */
    public function count()
    {
      return count($this->HierarchyNode);
    }

}
