<?php

namespace Eurostop\Products;

class ArrayOfExtendedAttributeValue implements \ArrayAccess, \Iterator, \Countable
{

    /**
     * @var ExtendedAttributeValue[] $ExtendedAttributeValue
     */
    protected $ExtendedAttributeValue = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return ExtendedAttributeValue[]
     */
    public function getExtendedAttributeValue()
    {
      return $this->ExtendedAttributeValue;
    }

    /**
     * @param ExtendedAttributeValue[] $ExtendedAttributeValue
     * @return \Eurostop\Products\ArrayOfExtendedAttributeValue
     */
    public function setExtendedAttributeValue(array $ExtendedAttributeValue = null)
    {
      $this->ExtendedAttributeValue = $ExtendedAttributeValue;
      return $this;
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset An offset to check for
     * @return boolean true on success or false on failure
     */
    public function offsetExists($offset)
    {
      return isset($this->ExtendedAttributeValue[$offset]);
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to retrieve
     * @return ExtendedAttributeValue
     */
    public function offsetGet($offset)
    {
      return $this->ExtendedAttributeValue[$offset];
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to assign the value to
     * @param ExtendedAttributeValue $value The value to set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
      if (!isset($offset)) {
        $this->ExtendedAttributeValue[] = $value;
      } else {
        $this->ExtendedAttributeValue[$offset] = $value;
      }
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to unset
     * @return void
     */
    public function offsetUnset($offset)
    {
      unset($this->ExtendedAttributeValue[$offset]);
    }

    /**
     * Iterator implementation
     *
     * @return ExtendedAttributeValue Return the current element
     */
    public function current()
    {
      return current($this->ExtendedAttributeValue);
    }

    /**
     * Iterator implementation
     * Move forward to next element
     *
     * @return void
     */
    public function next()
    {
      next($this->ExtendedAttributeValue);
    }

    /**
     * Iterator implementation
     *
     * @return string|null Return the key of the current element or null
     */
    public function key()
    {
      return key($this->ExtendedAttributeValue);
    }

    /**
     * Iterator implementation
     *
     * @return boolean Return the validity of the current position
     */
    public function valid()
    {
      return $this->key() !== null;
    }

    /**
     * Iterator implementation
     * Rewind the Iterator to the first element
     *
     * @return void
     */
    public function rewind()
    {
      reset($this->ExtendedAttributeValue);
    }

    /**
     * Countable implementation
     *
     * @return ExtendedAttributeValue Return count of elements
     */
    public function count()
    {
      return count($this->ExtendedAttributeValue);
    }

}
