<?php

namespace Eurostop\Organisation;

class SubmitVatRates
{

    /**
     * @var ArrayOfSubmittedVatRate $vatRates
     */
    protected $vatRates = null;

    /**
     * @var string $submissionReference
     */
    protected $submissionReference = null;

    /**
     * @param ArrayOfSubmittedVatRate $vatRates
     * @param string $submissionReference
     */
    public function __construct($vatRates, $submissionReference)
    {
      $this->vatRates = $vatRates;
      $this->submissionReference = $submissionReference;
    }

    /**
     * @return ArrayOfSubmittedVatRate
     */
    public function getVatRates()
    {
      return $this->vatRates;
    }

    /**
     * @param ArrayOfSubmittedVatRate $vatRates
     * @return \Eurostop\Organisation\SubmitVatRates
     */
    public function setVatRates($vatRates)
    {
      $this->vatRates = $vatRates;
      return $this;
    }

    /**
     * @return string
     */
    public function getSubmissionReference()
    {
      return $this->submissionReference;
    }

    /**
     * @param string $submissionReference
     * @return \Eurostop\Organisation\SubmitVatRates
     */
    public function setSubmissionReference($submissionReference)
    {
      $this->submissionReference = $submissionReference;
      return $this;
    }

}
