<?php

namespace Eurostop\Organisation;

class GetTaxRatesByAuthority
{

    /**
     * @var string $taxAuthorityIdentifier
     */
    protected $taxAuthorityIdentifier = null;

    /**
     * @var TaxAuthorityIdentifierType $taxAuthorityIdentifierType
     */
    protected $taxAuthorityIdentifierType = null;

    /**
     * @param string $taxAuthorityIdentifier
     * @param TaxAuthorityIdentifierType $taxAuthorityIdentifierType
     */
    public function __construct($taxAuthorityIdentifier, $taxAuthorityIdentifierType)
    {
      $this->taxAuthorityIdentifier = $taxAuthorityIdentifier;
      $this->taxAuthorityIdentifierType = $taxAuthorityIdentifierType;
    }

    /**
     * @return string
     */
    public function getTaxAuthorityIdentifier()
    {
      return $this->taxAuthorityIdentifier;
    }

    /**
     * @param string $taxAuthorityIdentifier
     * @return \Eurostop\Organisation\GetTaxRatesByAuthority
     */
    public function setTaxAuthorityIdentifier($taxAuthorityIdentifier)
    {
      $this->taxAuthorityIdentifier = $taxAuthorityIdentifier;
      return $this;
    }

    /**
     * @return TaxAuthorityIdentifierType
     */
    public function getTaxAuthorityIdentifierType()
    {
      return $this->taxAuthorityIdentifierType;
    }

    /**
     * @param TaxAuthorityIdentifierType $taxAuthorityIdentifierType
     * @return \Eurostop\Organisation\GetTaxRatesByAuthority
     */
    public function setTaxAuthorityIdentifierType($taxAuthorityIdentifierType)
    {
      $this->taxAuthorityIdentifierType = $taxAuthorityIdentifierType;
      return $this;
    }

}
