<?php

namespace Eurostop\Organisation;

class Branch extends CodedRetrievedDataItemOfBranchDtoTPKTiFnX
{

    /**
     * @var string $Address1
     */
    protected $Address1 = null;

    /**
     * @var string $Address2
     */
    protected $Address2 = null;

    /**
     * @var string $Address3
     */
    protected $Address3 = null;

    /**
     * @var string $Address4
     */
    protected $Address4 = null;

    /**
     * @var string $BranchClass
     */
    protected $BranchClass = null;

    /**
     * @var BranchType $BranchType
     */
    protected $BranchType = null;

    /**
     * @var string $BranchTypeCode
     */
    protected $BranchTypeCode = null;

    /**
     * @var string $CountryIdentifier
     */
    protected $CountryIdentifier = null;

    /**
     * @var string $Description
     */
    protected $Description = null;

    /**
     * @var string $PostCode
     */
    protected $PostCode = null;

    /**
     * @var int $TillCount
     */
    protected $TillCount = null;

    /**
     * @param BranchType $BranchType
     * @param int $TillCount
     */
    public function __construct($BranchType, $TillCount)
    {
      parent::__construct();
      $this->BranchType = $BranchType;
      $this->TillCount = $TillCount;
    }

    /**
     * @return string
     */
    public function getAddress1()
    {
      return $this->Address1;
    }

    /**
     * @param string $Address1
     * @return \Eurostop\Organisation\Branch
     */
    public function setAddress1($Address1)
    {
      $this->Address1 = $Address1;
      return $this;
    }

    /**
     * @return string
     */
    public function getAddress2()
    {
      return $this->Address2;
    }

    /**
     * @param string $Address2
     * @return \Eurostop\Organisation\Branch
     */
    public function setAddress2($Address2)
    {
      $this->Address2 = $Address2;
      return $this;
    }

    /**
     * @return string
     */
    public function getAddress3()
    {
      return $this->Address3;
    }

    /**
     * @param string $Address3
     * @return \Eurostop\Organisation\Branch
     */
    public function setAddress3($Address3)
    {
      $this->Address3 = $Address3;
      return $this;
    }

    /**
     * @return string
     */
    public function getAddress4()
    {
      return $this->Address4;
    }

    /**
     * @param string $Address4
     * @return \Eurostop\Organisation\Branch
     */
    public function setAddress4($Address4)
    {
      $this->Address4 = $Address4;
      return $this;
    }

    /**
     * @return string
     */
    public function getBranchClass()
    {
      return $this->BranchClass;
    }

    /**
     * @param string $BranchClass
     * @return \Eurostop\Organisation\Branch
     */
    public function setBranchClass($BranchClass)
    {
      $this->BranchClass = $BranchClass;
      return $this;
    }

    /**
     * @return BranchType
     */
    public function getBranchType()
    {
      return $this->BranchType;
    }

    /**
     * @param BranchType $BranchType
     * @return \Eurostop\Organisation\Branch
     */
    public function setBranchType($BranchType)
    {
      $this->BranchType = $BranchType;
      return $this;
    }

    /**
     * @return string
     */
    public function getBranchTypeCode()
    {
      return $this->BranchTypeCode;
    }

    /**
     * @param string $BranchTypeCode
     * @return \Eurostop\Organisation\Branch
     */
    public function setBranchTypeCode($BranchTypeCode)
    {
      $this->BranchTypeCode = $BranchTypeCode;
      return $this;
    }

    /**
     * @return string
     */
    public function getCountryIdentifier()
    {
      return $this->CountryIdentifier;
    }

    /**
     * @param string $CountryIdentifier
     * @return \Eurostop\Organisation\Branch
     */
    public function setCountryIdentifier($CountryIdentifier)
    {
      $this->CountryIdentifier = $CountryIdentifier;
      return $this;
    }

    /**
     * @return string
     */
    public function getDescription()
    {
      return $this->Description;
    }

    /**
     * @param string $Description
     * @return \Eurostop\Organisation\Branch
     */
    public function setDescription($Description)
    {
      $this->Description = $Description;
      return $this;
    }

    /**
     * @return string
     */
    public function getPostCode()
    {
      return $this->PostCode;
    }

    /**
     * @param string $PostCode
     * @return \Eurostop\Organisation\Branch
     */
    public function setPostCode($PostCode)
    {
      $this->PostCode = $PostCode;
      return $this;
    }

    /**
     * @return int
     */
    public function getTillCount()
    {
      return $this->TillCount;
    }

    /**
     * @param int $TillCount
     * @return \Eurostop\Organisation\Branch
     */
    public function setTillCount($TillCount)
    {
      $this->TillCount = $TillCount;
      return $this;
    }

}
