<?php

namespace Eurostop\Organisation;

class ArrayOfTaxRate implements \ArrayAccess, \Iterator, \Countable
{

    /**
     * @var TaxRate[] $TaxRate
     */
    protected $TaxRate = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return TaxRate[]
     */
    public function getTaxRate()
    {
      return $this->TaxRate;
    }

    /**
     * @param TaxRate[] $TaxRate
     * @return \Eurostop\Organisation\ArrayOfTaxRate
     */
    public function setTaxRate(array $TaxRate = null)
    {
      $this->TaxRate = $TaxRate;
      return $this;
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset An offset to check for
     * @return boolean true on success or false on failure
     */
    public function offsetExists($offset)
    {
      return isset($this->TaxRate[$offset]);
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to retrieve
     * @return TaxRate
     */
    public function offsetGet($offset)
    {
      return $this->TaxRate[$offset];
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to assign the value to
     * @param TaxRate $value The value to set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
      if (!isset($offset)) {
        $this->TaxRate[] = $value;
      } else {
        $this->TaxRate[$offset] = $value;
      }
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to unset
     * @return void
     */
    public function offsetUnset($offset)
    {
      unset($this->TaxRate[$offset]);
    }

    /**
     * Iterator implementation
     *
     * @return TaxRate Return the current element
     */
    public function current()
    {
      return current($this->TaxRate);
    }

    /**
     * Iterator implementation
     * Move forward to next element
     *
     * @return void
     */
    public function next()
    {
      next($this->TaxRate);
    }

    /**
     * Iterator implementation
     *
     * @return string|null Return the key of the current element or null
     */
    public function key()
    {
      return key($this->TaxRate);
    }

    /**
     * Iterator implementation
     *
     * @return boolean Return the validity of the current position
     */
    public function valid()
    {
      return $this->key() !== null;
    }

    /**
     * Iterator implementation
     * Rewind the Iterator to the first element
     *
     * @return void
     */
    public function rewind()
    {
      reset($this->TaxRate);
    }

    /**
     * Countable implementation
     *
     * @return TaxRate Return count of elements
     */
    public function count()
    {
      return count($this->TaxRate);
    }

}
