<?php

namespace Eurostop\Organisation;

class ArrayOfTaxAuthority implements \ArrayAccess, \Iterator, \Countable
{

    /**
     * @var TaxAuthority[] $TaxAuthority
     */
    protected $TaxAuthority = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return TaxAuthority[]
     */
    public function getTaxAuthority()
    {
      return $this->TaxAuthority;
    }

    /**
     * @param TaxAuthority[] $TaxAuthority
     * @return \Eurostop\Organisation\ArrayOfTaxAuthority
     */
    public function setTaxAuthority(array $TaxAuthority = null)
    {
      $this->TaxAuthority = $TaxAuthority;
      return $this;
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset An offset to check for
     * @return boolean true on success or false on failure
     */
    public function offsetExists($offset)
    {
      return isset($this->TaxAuthority[$offset]);
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to retrieve
     * @return TaxAuthority
     */
    public function offsetGet($offset)
    {
      return $this->TaxAuthority[$offset];
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to assign the value to
     * @param TaxAuthority $value The value to set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
      if (!isset($offset)) {
        $this->TaxAuthority[] = $value;
      } else {
        $this->TaxAuthority[$offset] = $value;
      }
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to unset
     * @return void
     */
    public function offsetUnset($offset)
    {
      unset($this->TaxAuthority[$offset]);
    }

    /**
     * Iterator implementation
     *
     * @return TaxAuthority Return the current element
     */
    public function current()
    {
      return current($this->TaxAuthority);
    }

    /**
     * Iterator implementation
     * Move forward to next element
     *
     * @return void
     */
    public function next()
    {
      next($this->TaxAuthority);
    }

    /**
     * Iterator implementation
     *
     * @return string|null Return the key of the current element or null
     */
    public function key()
    {
      return key($this->TaxAuthority);
    }

    /**
     * Iterator implementation
     *
     * @return boolean Return the validity of the current position
     */
    public function valid()
    {
      return $this->key() !== null;
    }

    /**
     * Iterator implementation
     * Rewind the Iterator to the first element
     *
     * @return void
     */
    public function rewind()
    {
      reset($this->TaxAuthority);
    }

    /**
     * Countable implementation
     *
     * @return TaxAuthority Return count of elements
     */
    public function count()
    {
      return count($this->TaxAuthority);
    }

}
