<?php

namespace Eurostop\Loyalty;

class GetCustomerByIdentifier
{

    /**
     * @var string $customerIdentifier
     */
    protected $customerIdentifier = null;

    /**
     * @var CustomerIdentifierType $customerIdentifierType
     */
    protected $customerIdentifierType = null;

    /**
     * @param string $customerIdentifier
     * @param CustomerIdentifierType $customerIdentifierType
     */
    public function __construct($customerIdentifier, $customerIdentifierType)
    {
      $this->customerIdentifier = $customerIdentifier;
      $this->customerIdentifierType = $customerIdentifierType;
    }

    /**
     * @return string
     */
    public function getCustomerIdentifier()
    {
      return $this->customerIdentifier;
    }

    /**
     * @param string $customerIdentifier
     * @return \Eurostop\Loyalty\GetCustomerByIdentifier
     */
    public function setCustomerIdentifier($customerIdentifier)
    {
      $this->customerIdentifier = $customerIdentifier;
      return $this;
    }

    /**
     * @return CustomerIdentifierType
     */
    public function getCustomerIdentifierType()
    {
      return $this->customerIdentifierType;
    }

    /**
     * @param CustomerIdentifierType $customerIdentifierType
     * @return \Eurostop\Loyalty\GetCustomerByIdentifier
     */
    public function setCustomerIdentifierType($customerIdentifierType)
    {
      $this->customerIdentifierType = $customerIdentifierType;
      return $this;
    }

}
