<?php

namespace Eurostop\Loyalty;

class CustomerAttributeType extends CodedRetrievedDataItemOfCustomerAttributeTypeDtoKJ8WzcEX
{

    /**
     * @var string $AttributeName
     */
    protected $AttributeName = null;

    /**
     * @var int $AttributeNumber
     */
    protected $AttributeNumber = null;

    /**
     * @var ArrayOfstring $Classifications
     */
    protected $Classifications = null;

    /**
     * @var CustomerDataEncryptionType $EncryptionType
     */
    protected $EncryptionType = null;

    /**
     * @var boolean $IsRequired
     */
    protected $IsRequired = null;

    /**
     * @param int $AttributeNumber
     * @param CustomerDataEncryptionType $EncryptionType
     * @param boolean $IsRequired
     */
    public function __construct($AttributeNumber, $EncryptionType, $IsRequired)
    {
      parent::__construct();
      $this->AttributeNumber = $AttributeNumber;
      $this->EncryptionType = $EncryptionType;
      $this->IsRequired = $IsRequired;
    }

    /**
     * @return string
     */
    public function getAttributeName()
    {
      return $this->AttributeName;
    }

    /**
     * @param string $AttributeName
     * @return \Eurostop\Loyalty\CustomerAttributeType
     */
    public function setAttributeName($AttributeName)
    {
      $this->AttributeName = $AttributeName;
      return $this;
    }

    /**
     * @return int
     */
    public function getAttributeNumber()
    {
      return $this->AttributeNumber;
    }

    /**
     * @param int $AttributeNumber
     * @return \Eurostop\Loyalty\CustomerAttributeType
     */
    public function setAttributeNumber($AttributeNumber)
    {
      $this->AttributeNumber = $AttributeNumber;
      return $this;
    }

    /**
     * @return ArrayOfstring
     */
    public function getClassifications()
    {
      return $this->Classifications;
    }

    /**
     * @param ArrayOfstring $Classifications
     * @return \Eurostop\Loyalty\CustomerAttributeType
     */
    public function setClassifications($Classifications)
    {
      $this->Classifications = $Classifications;
      return $this;
    }

    /**
     * @return CustomerDataEncryptionType
     */
    public function getEncryptionType()
    {
      return $this->EncryptionType;
    }

    /**
     * @param CustomerDataEncryptionType $EncryptionType
     * @return \Eurostop\Loyalty\CustomerAttributeType
     */
    public function setEncryptionType($EncryptionType)
    {
      $this->EncryptionType = $EncryptionType;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getIsRequired()
    {
      return $this->IsRequired;
    }

    /**
     * @param boolean $IsRequired
     * @return \Eurostop\Loyalty\CustomerAttributeType
     */
    public function setIsRequired($IsRequired)
    {
      $this->IsRequired = $IsRequired;
      return $this;
    }

}
