<?php

namespace Eurostop\Loyalty;

class ArrayOfCustomerAttributeType implements \ArrayAccess, \Iterator, \Countable
{

    /**
     * @var CustomerAttributeType[] $CustomerAttributeType
     */
    protected $CustomerAttributeType = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return CustomerAttributeType[]
     */
    public function getCustomerAttributeType()
    {
      return $this->CustomerAttributeType;
    }

    /**
     * @param CustomerAttributeType[] $CustomerAttributeType
     * @return \Eurostop\Loyalty\ArrayOfCustomerAttributeType
     */
    public function setCustomerAttributeType(array $CustomerAttributeType = null)
    {
      $this->CustomerAttributeType = $CustomerAttributeType;
      return $this;
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset An offset to check for
     * @return boolean true on success or false on failure
     */
    public function offsetExists($offset)
    {
      return isset($this->CustomerAttributeType[$offset]);
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to retrieve
     * @return CustomerAttributeType
     */
    public function offsetGet($offset)
    {
      return $this->CustomerAttributeType[$offset];
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to assign the value to
     * @param CustomerAttributeType $value The value to set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
      if (!isset($offset)) {
        $this->CustomerAttributeType[] = $value;
      } else {
        $this->CustomerAttributeType[$offset] = $value;
      }
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to unset
     * @return void
     */
    public function offsetUnset($offset)
    {
      unset($this->CustomerAttributeType[$offset]);
    }

    /**
     * Iterator implementation
     *
     * @return CustomerAttributeType Return the current element
     */
    public function current()
    {
      return current($this->CustomerAttributeType);
    }

    /**
     * Iterator implementation
     * Move forward to next element
     *
     * @return void
     */
    public function next()
    {
      next($this->CustomerAttributeType);
    }

    /**
     * Iterator implementation
     *
     * @return string|null Return the key of the current element or null
     */
    public function key()
    {
      return key($this->CustomerAttributeType);
    }

    /**
     * Iterator implementation
     *
     * @return boolean Return the validity of the current position
     */
    public function valid()
    {
      return $this->key() !== null;
    }

    /**
     * Iterator implementation
     * Rewind the Iterator to the first element
     *
     * @return void
     */
    public function rewind()
    {
      reset($this->CustomerAttributeType);
    }

    /**
     * Countable implementation
     *
     * @return CustomerAttributeType Return count of elements
     */
    public function count()
    {
      return count($this->CustomerAttributeType);
    }

}
