<?php

namespace Eurostop\Fulfilment;

class SubmittedCustomerOrderShipment extends SubmittedDataItemOfSubmittedCustomerOrderShipmentDtoHay9ORuz
{

    /**
     * @var BranchIdentifierType $BranchIdentifierType
     */
    protected $BranchIdentifierType = null;

    /**
     * @var string $CarrierIdentifier
     */
    protected $CarrierIdentifier = null;

    /**
     * @var string $Comments
     */
    protected $Comments = null;

    /**
     * @var string $CustomerOrderIdentifier
     */
    protected $CustomerOrderIdentifier = null;

    /**
     * @var CustomerOrderIdentifierType $CustomerOrderIdentifierType
     */
    protected $CustomerOrderIdentifierType = null;

    /**
     * @var string $DeliveryService
     */
    protected $DeliveryService = null;

    /**
     * @var ArrayOfSubmittedCustomerOrderShipmentDetail $Lines
     */
    protected $Lines = null;

    /**
     * @var int $ShipmentNumber
     */
    protected $ShipmentNumber = null;

    /**
     * @var \DateTime $ShippedDate
     */
    protected $ShippedDate = null;

    /**
     * @var string $SourceBranchIdentifier
     */
    protected $SourceBranchIdentifier = null;

    /**
     * @var string $TrackingInformation
     */
    protected $TrackingInformation = null;

    /**
     * @param CustomerOrderIdentifierType $CustomerOrderIdentifierType
     * @param \DateTime $ShippedDate
     */
    public function __construct($CustomerOrderIdentifierType, \DateTime $ShippedDate)
    {
      parent::__construct();
      $this->CustomerOrderIdentifierType = $CustomerOrderIdentifierType;
      $this->ShippedDate = $ShippedDate->format(\DateTime::ATOM);
    }

    /**
     * @return BranchIdentifierType
     */
    public function getBranchIdentifierType()
    {
      return $this->BranchIdentifierType;
    }

    /**
     * @param BranchIdentifierType $BranchIdentifierType
     * @return \Eurostop\Fulfilment\SubmittedCustomerOrderShipment
     */
    public function setBranchIdentifierType($BranchIdentifierType)
    {
      $this->BranchIdentifierType = $BranchIdentifierType;
      return $this;
    }

    /**
     * @return string
     */
    public function getCarrierIdentifier()
    {
      return $this->CarrierIdentifier;
    }

    /**
     * @param string $CarrierIdentifier
     * @return \Eurostop\Fulfilment\SubmittedCustomerOrderShipment
     */
    public function setCarrierIdentifier($CarrierIdentifier)
    {
      $this->CarrierIdentifier = $CarrierIdentifier;
      return $this;
    }

    /**
     * @return string
     */
    public function getComments()
    {
      return $this->Comments;
    }

    /**
     * @param string $Comments
     * @return \Eurostop\Fulfilment\SubmittedCustomerOrderShipment
     */
    public function setComments($Comments)
    {
      $this->Comments = $Comments;
      return $this;
    }

    /**
     * @return string
     */
    public function getCustomerOrderIdentifier()
    {
      return $this->CustomerOrderIdentifier;
    }

    /**
     * @param string $CustomerOrderIdentifier
     * @return \Eurostop\Fulfilment\SubmittedCustomerOrderShipment
     */
    public function setCustomerOrderIdentifier($CustomerOrderIdentifier)
    {
      $this->CustomerOrderIdentifier = $CustomerOrderIdentifier;
      return $this;
    }

    /**
     * @return CustomerOrderIdentifierType
     */
    public function getCustomerOrderIdentifierType()
    {
      return $this->CustomerOrderIdentifierType;
    }

    /**
     * @param CustomerOrderIdentifierType $CustomerOrderIdentifierType
     * @return \Eurostop\Fulfilment\SubmittedCustomerOrderShipment
     */
    public function setCustomerOrderIdentifierType($CustomerOrderIdentifierType)
    {
      $this->CustomerOrderIdentifierType = $CustomerOrderIdentifierType;
      return $this;
    }

    /**
     * @return string
     */
    public function getDeliveryService()
    {
      return $this->DeliveryService;
    }

    /**
     * @param string $DeliveryService
     * @return \Eurostop\Fulfilment\SubmittedCustomerOrderShipment
     */
    public function setDeliveryService($DeliveryService)
    {
      $this->DeliveryService = $DeliveryService;
      return $this;
    }

    /**
     * @return ArrayOfSubmittedCustomerOrderShipmentDetail
     */
    public function getLines()
    {
      return $this->Lines;
    }

    /**
     * @param ArrayOfSubmittedCustomerOrderShipmentDetail $Lines
     * @return \Eurostop\Fulfilment\SubmittedCustomerOrderShipment
     */
    public function setLines($Lines)
    {
      $this->Lines = $Lines;
      return $this;
    }

    /**
     * @return int
     */
    public function getShipmentNumber()
    {
      return $this->ShipmentNumber;
    }

    /**
     * @param int $ShipmentNumber
     * @return \Eurostop\Fulfilment\SubmittedCustomerOrderShipment
     */
    public function setShipmentNumber($ShipmentNumber)
    {
      $this->ShipmentNumber = $ShipmentNumber;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getShippedDate()
    {
      if ($this->ShippedDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->ShippedDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $ShippedDate
     * @return \Eurostop\Fulfilment\SubmittedCustomerOrderShipment
     */
    public function setShippedDate(\DateTime $ShippedDate)
    {
      $this->ShippedDate = $ShippedDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return string
     */
    public function getSourceBranchIdentifier()
    {
      return $this->SourceBranchIdentifier;
    }

    /**
     * @param string $SourceBranchIdentifier
     * @return \Eurostop\Fulfilment\SubmittedCustomerOrderShipment
     */
    public function setSourceBranchIdentifier($SourceBranchIdentifier)
    {
      $this->SourceBranchIdentifier = $SourceBranchIdentifier;
      return $this;
    }

    /**
     * @return string
     */
    public function getTrackingInformation()
    {
      return $this->TrackingInformation;
    }

    /**
     * @param string $TrackingInformation
     * @return \Eurostop\Fulfilment\SubmittedCustomerOrderShipment
     */
    public function setTrackingInformation($TrackingInformation)
    {
      $this->TrackingInformation = $TrackingInformation;
      return $this;
    }

}
