<?php

namespace Eurostop\Fulfilment;

class SubmitCustomerOrderStockSource
{

    /**
     * @var SubmittedCustomerOrderStockSource $customerOrderStockSource
     */
    protected $customerOrderStockSource = null;

    /**
     * @var string $submissionReference
     */
    protected $submissionReference = null;

    /**
     * @param SubmittedCustomerOrderStockSource $customerOrderStockSource
     * @param string $submissionReference
     */
    public function __construct($customerOrderStockSource, $submissionReference)
    {
      $this->customerOrderStockSource = $customerOrderStockSource;
      $this->submissionReference = $submissionReference;
    }

    /**
     * @return SubmittedCustomerOrderStockSource
     */
    public function getCustomerOrderStockSource()
    {
      return $this->customerOrderStockSource;
    }

    /**
     * @param SubmittedCustomerOrderStockSource $customerOrderStockSource
     * @return \Eurostop\Fulfilment\SubmitCustomerOrderStockSource
     */
    public function setCustomerOrderStockSource($customerOrderStockSource)
    {
      $this->customerOrderStockSource = $customerOrderStockSource;
      return $this;
    }

    /**
     * @return string
     */
    public function getSubmissionReference()
    {
      return $this->submissionReference;
    }

    /**
     * @param string $submissionReference
     * @return \Eurostop\Fulfilment\SubmitCustomerOrderStockSource
     */
    public function setSubmissionReference($submissionReference)
    {
      $this->submissionReference = $submissionReference;
      return $this;
    }

}
