<?php

namespace Eurostop\Fulfilment;

class SubmitCustomerOrderShipments
{

    /**
     * @var ArrayOfSubmittedCustomerOrderShipment $customerOrderShipments
     */
    protected $customerOrderShipments = null;

    /**
     * @var string $submissionReference
     */
    protected $submissionReference = null;

    /**
     * @param ArrayOfSubmittedCustomerOrderShipment $customerOrderShipments
     * @param string $submissionReference
     */
    public function __construct($customerOrderShipments, $submissionReference)
    {
      $this->customerOrderShipments = $customerOrderShipments;
      $this->submissionReference = $submissionReference;
    }

    /**
     * @return ArrayOfSubmittedCustomerOrderShipment
     */
    public function getCustomerOrderShipments()
    {
      return $this->customerOrderShipments;
    }

    /**
     * @param ArrayOfSubmittedCustomerOrderShipment $customerOrderShipments
     * @return \Eurostop\Fulfilment\SubmitCustomerOrderShipments
     */
    public function setCustomerOrderShipments($customerOrderShipments)
    {
      $this->customerOrderShipments = $customerOrderShipments;
      return $this;
    }

    /**
     * @return string
     */
    public function getSubmissionReference()
    {
      return $this->submissionReference;
    }

    /**
     * @param string $submissionReference
     * @return \Eurostop\Fulfilment\SubmitCustomerOrderShipments
     */
    public function setSubmissionReference($submissionReference)
    {
      $this->submissionReference = $submissionReference;
      return $this;
    }

}
