<?php

namespace Eurostop\Fulfilment;

class CustomerOrderLine extends RetrievedDataItemOfCustomerOrderLineDtoHay9ORuz
{

    /**
     * @var \DateTime $CancelledDate
     */
    protected $CancelledDate = null;

    /**
     * @var int $CancelledExternallyQuantity
     */
    protected $CancelledExternallyQuantity = null;

    /**
     * @var int $CancelledInternallyQuantity
     */
    protected $CancelledInternallyQuantity = null;

    /**
     * @var int $LineNumber
     */
    protected $LineNumber = null;

    /**
     * @var int $OrderedQuantity
     */
    protected $OrderedQuantity = null;

    /**
     * @var string $ProductIdentifier
     */
    protected $ProductIdentifier = null;

    /**
     * @var int $ShippedQuantity
     */
    protected $ShippedQuantity = null;

    /**
     * @var string $SkuIdentifier
     */
    protected $SkuIdentifier = null;

    /**
     * @var int $TotalCancelledQuantity
     */
    protected $TotalCancelledQuantity = null;

    /**
     * @param int $CancelledExternallyQuantity
     * @param int $CancelledInternallyQuantity
     * @param int $LineNumber
     * @param int $OrderedQuantity
     * @param int $ShippedQuantity
     * @param int $TotalCancelledQuantity
     */
    public function __construct($CancelledExternallyQuantity, $CancelledInternallyQuantity, $LineNumber, $OrderedQuantity, $ShippedQuantity, $TotalCancelledQuantity)
    {
      parent::__construct();
      $this->CancelledExternallyQuantity = $CancelledExternallyQuantity;
      $this->CancelledInternallyQuantity = $CancelledInternallyQuantity;
      $this->LineNumber = $LineNumber;
      $this->OrderedQuantity = $OrderedQuantity;
      $this->ShippedQuantity = $ShippedQuantity;
      $this->TotalCancelledQuantity = $TotalCancelledQuantity;
    }

    /**
     * @return \DateTime
     */
    public function getCancelledDate()
    {
      if ($this->CancelledDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->CancelledDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $CancelledDate
     * @return \Eurostop\Fulfilment\CustomerOrderLine
     */
    public function setCancelledDate(\DateTime $CancelledDate = null)
    {
      if ($CancelledDate == null) {
       $this->CancelledDate = null;
      } else {
        $this->CancelledDate = $CancelledDate->format(\DateTime::ATOM);
      }
      return $this;
    }

    /**
     * @return int
     */
    public function getCancelledExternallyQuantity()
    {
      return $this->CancelledExternallyQuantity;
    }

    /**
     * @param int $CancelledExternallyQuantity
     * @return \Eurostop\Fulfilment\CustomerOrderLine
     */
    public function setCancelledExternallyQuantity($CancelledExternallyQuantity)
    {
      $this->CancelledExternallyQuantity = $CancelledExternallyQuantity;
      return $this;
    }

    /**
     * @return int
     */
    public function getCancelledInternallyQuantity()
    {
      return $this->CancelledInternallyQuantity;
    }

    /**
     * @param int $CancelledInternallyQuantity
     * @return \Eurostop\Fulfilment\CustomerOrderLine
     */
    public function setCancelledInternallyQuantity($CancelledInternallyQuantity)
    {
      $this->CancelledInternallyQuantity = $CancelledInternallyQuantity;
      return $this;
    }

    /**
     * @return int
     */
    public function getLineNumber()
    {
      return $this->LineNumber;
    }

    /**
     * @param int $LineNumber
     * @return \Eurostop\Fulfilment\CustomerOrderLine
     */
    public function setLineNumber($LineNumber)
    {
      $this->LineNumber = $LineNumber;
      return $this;
    }

    /**
     * @return int
     */
    public function getOrderedQuantity()
    {
      return $this->OrderedQuantity;
    }

    /**
     * @param int $OrderedQuantity
     * @return \Eurostop\Fulfilment\CustomerOrderLine
     */
    public function setOrderedQuantity($OrderedQuantity)
    {
      $this->OrderedQuantity = $OrderedQuantity;
      return $this;
    }

    /**
     * @return string
     */
    public function getProductIdentifier()
    {
      return $this->ProductIdentifier;
    }

    /**
     * @param string $ProductIdentifier
     * @return \Eurostop\Fulfilment\CustomerOrderLine
     */
    public function setProductIdentifier($ProductIdentifier)
    {
      $this->ProductIdentifier = $ProductIdentifier;
      return $this;
    }

    /**
     * @return int
     */
    public function getShippedQuantity()
    {
      return $this->ShippedQuantity;
    }

    /**
     * @param int $ShippedQuantity
     * @return \Eurostop\Fulfilment\CustomerOrderLine
     */
    public function setShippedQuantity($ShippedQuantity)
    {
      $this->ShippedQuantity = $ShippedQuantity;
      return $this;
    }

    /**
     * @return string
     */
    public function getSkuIdentifier()
    {
      return $this->SkuIdentifier;
    }

    /**
     * @param string $SkuIdentifier
     * @return \Eurostop\Fulfilment\CustomerOrderLine
     */
    public function setSkuIdentifier($SkuIdentifier)
    {
      $this->SkuIdentifier = $SkuIdentifier;
      return $this;
    }

    /**
     * @return int
     */
    public function getTotalCancelledQuantity()
    {
      return $this->TotalCancelledQuantity;
    }

    /**
     * @param int $TotalCancelledQuantity
     * @return \Eurostop\Fulfilment\CustomerOrderLine
     */
    public function setTotalCancelledQuantity($TotalCancelledQuantity)
    {
      $this->TotalCancelledQuantity = $TotalCancelledQuantity;
      return $this;
    }

}
