<?php

namespace Eurostop\Stocks;

class WriteOnOffHeaderCustom extends CodedRetrievedDataItemOfWriteOnOffHeaderDto6qbTdoQxCustom
{

    /**
     * @var string $BranchIdentifier
     */
    protected $BranchIdentifier = null;

    /**
     * @var \DateTime $ConfirmedDate
     */
    protected $ConfirmedDate = null;

    /**
     * @var \DateTime $CreatedDate
     */
    protected $CreatedDate = null;

    /**
     * @var ArrayOfWriteOnOffDetail $Lines
     */
    protected $Lines = null;

    /**
     * @var string $Reference
     */
    protected $Reference = null;

    /**
     * @param \DateTime $CreatedDate
     */
    public function __construct(\DateTime $CreatedDate)
    {
      parent::__construct();
      $this->CreatedDate = $CreatedDate->format(\DateTime::ATOM);
    }

    /**
     * @return string
     */
    public function getBranchIdentifier()
    {
      return $this->BranchIdentifier;
    }

    /**
     * @param string $BranchIdentifier
     * @return \Eurostop\Stocks\WriteOnOffHeader
     */
    public function setBranchIdentifier($BranchIdentifier)
    {
      $this->BranchIdentifier = $BranchIdentifier;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getConfirmedDate()
    {
      if ($this->ConfirmedDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->ConfirmedDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $ConfirmedDate
     * @return \Eurostop\Stocks\WriteOnOffHeader
     */
    public function setConfirmedDate(\DateTime $ConfirmedDate = null)
    {
      if ($ConfirmedDate == null) {
       $this->ConfirmedDate = null;
      } else {
        $this->ConfirmedDate = $ConfirmedDate->format(\DateTime::ATOM);
      }
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getCreatedDate()
    {
      if ($this->CreatedDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->CreatedDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $CreatedDate
     * @return \Eurostop\Stocks\WriteOnOffHeader
     */
    public function setCreatedDate(\DateTime $CreatedDate)
    {
      $this->CreatedDate = $CreatedDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return ArrayOfWriteOnOffDetail
     */
    public function getLines()
    {
      return $this->Lines;
    }

    /**
     * @param ArrayOfWriteOnOffDetail $Lines
     * @return \Eurostop\Stocks\WriteOnOffHeader
     */
    public function setLines($Lines)
    {
      $this->Lines = $Lines;
      return $this;
    }

    /**
     * @return string
     */
    public function getReference()
    {
      return $this->Reference;
    }

    /**
     * @param string $Reference
     * @return \Eurostop\Stocks\WriteOnOffHeader
     */
    public function setReference($Reference)
    {
      $this->Reference = $Reference;
      return $this;
    }

}
