<?php

namespace Eurostop\Stocks;

class SubmittedAllocationHeader extends SubmittedDataItemOfSubmittedAllocationHeaderDto6qbTdoQx
{

    /**
     * @var string $DeliveryIdentifier
     */
    protected $DeliveryIdentifier = null;

    /**
     * @var DeliveryIdentifierType $DeliveryIdentifierType
     */
    protected $DeliveryIdentifierType = null;

    /**
     * @var ArrayOfSubmittedAllocationItem $Lines
     */
    protected $Lines = null;

    /**
     * @var string $PurchaseOrderIdentifier
     */
    protected $PurchaseOrderIdentifier = null;

    /**
     * @var PurchaseOrderIdentifierType $PurchaseOrderIdentifierType
     */
    protected $PurchaseOrderIdentifierType = null;

    /**
     * @var string $Reference
     */
    protected $Reference = null;

    /**
     * @var AllocationStatus $Status
     */
    protected $Status = null;

    /**
     * @var string $WarehouseIdentifier
     */
    protected $WarehouseIdentifier = null;

    /**
     * @var BranchIdentifierType $WarehouseIdentifierType
     */
    protected $WarehouseIdentifierType = null;

    /**
     * @param DeliveryIdentifierType $DeliveryIdentifierType
     * @param PurchaseOrderIdentifierType $PurchaseOrderIdentifierType
     * @param AllocationStatus $Status
     * @param BranchIdentifierType $WarehouseIdentifierType
     */
    public function __construct($DeliveryIdentifierType, $PurchaseOrderIdentifierType, $Status, $WarehouseIdentifierType)
    {
      parent::__construct();
      $this->DeliveryIdentifierType = $DeliveryIdentifierType;
      $this->PurchaseOrderIdentifierType = $PurchaseOrderIdentifierType;
      $this->Status = $Status;
      $this->WarehouseIdentifierType = $WarehouseIdentifierType;
    }

    /**
     * @return string
     */
    public function getDeliveryIdentifier()
    {
      return $this->DeliveryIdentifier;
    }

    /**
     * @param string $DeliveryIdentifier
     * @return \Eurostop\Stocks\SubmittedAllocationHeader
     */
    public function setDeliveryIdentifier($DeliveryIdentifier)
    {
      $this->DeliveryIdentifier = $DeliveryIdentifier;
      return $this;
    }

    /**
     * @return DeliveryIdentifierType
     */
    public function getDeliveryIdentifierType()
    {
      return $this->DeliveryIdentifierType;
    }

    /**
     * @param DeliveryIdentifierType $DeliveryIdentifierType
     * @return \Eurostop\Stocks\SubmittedAllocationHeader
     */
    public function setDeliveryIdentifierType($DeliveryIdentifierType)
    {
      $this->DeliveryIdentifierType = $DeliveryIdentifierType;
      return $this;
    }

    /**
     * @return ArrayOfSubmittedAllocationItem
     */
    public function getLines()
    {
      return $this->Lines;
    }

    /**
     * @param ArrayOfSubmittedAllocationItem $Lines
     * @return \Eurostop\Stocks\SubmittedAllocationHeader
     */
    public function setLines($Lines)
    {
      $this->Lines = $Lines;
      return $this;
    }

    /**
     * @return string
     */
    public function getPurchaseOrderIdentifier()
    {
      return $this->PurchaseOrderIdentifier;
    }

    /**
     * @param string $PurchaseOrderIdentifier
     * @return \Eurostop\Stocks\SubmittedAllocationHeader
     */
    public function setPurchaseOrderIdentifier($PurchaseOrderIdentifier)
    {
      $this->PurchaseOrderIdentifier = $PurchaseOrderIdentifier;
      return $this;
    }

    /**
     * @return PurchaseOrderIdentifierType
     */
    public function getPurchaseOrderIdentifierType()
    {
      return $this->PurchaseOrderIdentifierType;
    }

    /**
     * @param PurchaseOrderIdentifierType $PurchaseOrderIdentifierType
     * @return \Eurostop\Stocks\SubmittedAllocationHeader
     */
    public function setPurchaseOrderIdentifierType($PurchaseOrderIdentifierType)
    {
      $this->PurchaseOrderIdentifierType = $PurchaseOrderIdentifierType;
      return $this;
    }

    /**
     * @return string
     */
    public function getReference()
    {
      return $this->Reference;
    }

    /**
     * @param string $Reference
     * @return \Eurostop\Stocks\SubmittedAllocationHeader
     */
    public function setReference($Reference)
    {
      $this->Reference = $Reference;
      return $this;
    }

    /**
     * @return AllocationStatus
     */
    public function getStatus()
    {
      return $this->Status;
    }

    /**
     * @param AllocationStatus $Status
     * @return \Eurostop\Stocks\SubmittedAllocationHeader
     */
    public function setStatus($Status)
    {
      $this->Status = $Status;
      return $this;
    }

    /**
     * @return string
     */
    public function getWarehouseIdentifier()
    {
      return $this->WarehouseIdentifier;
    }

    /**
     * @param string $WarehouseIdentifier
     * @return \Eurostop\Stocks\SubmittedAllocationHeader
     */
    public function setWarehouseIdentifier($WarehouseIdentifier)
    {
      $this->WarehouseIdentifier = $WarehouseIdentifier;
      return $this;
    }

    /**
     * @return BranchIdentifierType
     */
    public function getWarehouseIdentifierType()
    {
      return $this->WarehouseIdentifierType;
    }

    /**
     * @param BranchIdentifierType $WarehouseIdentifierType
     * @return \Eurostop\Stocks\SubmittedAllocationHeader
     */
    public function setWarehouseIdentifierType($WarehouseIdentifierType)
    {
      $this->WarehouseIdentifierType = $WarehouseIdentifierType;
      return $this;
    }

}
