<?php

namespace Eurostop\Stocks;

class SubmitTransfers
{

    /**
     * @var ArrayOfSubmittedTransferLine $transfers
     */
    protected $transfers = null;

    /**
     * @var string $submissionReference
     */
    protected $submissionReference = null;

    /**
     * @param ArrayOfSubmittedTransferLine $transfers
     * @param string $submissionReference
     */
    public function __construct($transfers = null, $submissionReference = null)
    {
      $this->transfers = $transfers;
      $this->submissionReference = $submissionReference;
    }

    /**
     * @return ArrayOfSubmittedTransferLine
     */
    public function getTransfers()
    {
      return $this->transfers;
    }

    /**
     * @param ArrayOfSubmittedTransferLine $transfers
     * @return \Eurostop\Stocks\SubmitTransfers
     */
    public function setTransfers($transfers)
    {
      $this->transfers = $transfers;
      return $this;
    }

    /**
     * @return string
     */
    public function getSubmissionReference()
    {
      return $this->submissionReference;
    }

    /**
     * @param string $submissionReference
     * @return \Eurostop\Stocks\SubmitTransfers
     */
    public function setSubmissionReference($submissionReference)
    {
      $this->submissionReference = $submissionReference;
      return $this;
    }

}
