<?php

namespace Eurostop\Stocks;

class SubmitTransferActions
{

    /**
     * @var ArrayOfSubmittedTransferAction $transferActions
     */
    protected $transferActions = null;

    /**
     * @var string $submissionReference
     */
    protected $submissionReference = null;

    /**
     * @param ArrayOfSubmittedTransferAction $transferActions
     * @param string $submissionReference
     */
    public function __construct($transferActions, $submissionReference)
    {
      $this->transferActions = $transferActions;
      $this->submissionReference = $submissionReference;
    }

    /**
     * @return ArrayOfSubmittedTransferAction
     */
    public function getTransferActions()
    {
      return $this->transferActions;
    }

    /**
     * @param ArrayOfSubmittedTransferAction $transferActions
     * @return \Eurostop\Stocks\SubmitTransferActions
     */
    public function setTransferActions($transferActions)
    {
      $this->transferActions = $transferActions;
      return $this;
    }

    /**
     * @return string
     */
    public function getSubmissionReference()
    {
      return $this->submissionReference;
    }

    /**
     * @param string $submissionReference
     * @return \Eurostop\Stocks\SubmitTransferActions
     */
    public function setSubmissionReference($submissionReference)
    {
      $this->submissionReference = $submissionReference;
      return $this;
    }

}
