<?php

namespace Eurostop\Stocks;

class SubmitTillTransfers
{

    /**
     * @var ArrayOfSubmittedTillTransferLine $tillTransfers
     */
    protected $tillTransfers = null;

    /**
     * @var string $submissionReference
     */
    protected $submissionReference = null;

    /**
     * @param ArrayOfSubmittedTillTransferLine $tillTransfers
     * @param string $submissionReference
     */
    public function __construct($tillTransfers = null, $submissionReference = null)
    {
      $this->tillTransfers = $tillTransfers;
      $this->submissionReference = $submissionReference;
    }

    /**
     * @return ArrayOfSubmittedTillTransferLine
     */
    public function getTillTransfers()
    {
      return $this->tillTransfers;
    }

    /**
     * @param ArrayOfSubmittedTillTransferLine $tillTransfers
     * @return \Eurostop\Stocks\SubmitTillTransfers
     */
    public function setTillTransfers($tillTransfers)
    {
      $this->tillTransfers = $tillTransfers;
      return $this;
    }

    /**
     * @return string
     */
    public function getSubmissionReference()
    {
      return $this->submissionReference;
    }

    /**
     * @param string $submissionReference
     * @return \Eurostop\Stocks\SubmitTillTransfers
     */
    public function setSubmissionReference($submissionReference)
    {
      $this->submissionReference = $submissionReference;
      return $this;
    }

}
