<?php

namespace Eurostop\Stocks;

class StockWebServiceInterfacePlugin extends \SoapClient
{

    /**
     * @var array $classmap The defined classes
     */
    private static $classmap = array (
      'Stock' => 'Eurostop\\Stocks\\Stock',
      'ArrayOfStock' => 'Eurostop\\Stocks\\ArrayOfStock',
      'ArrayOfSubmittedStockPosition' => 'Eurostop\\Stocks\\ArrayOfSubmittedStockPosition',
      'SubmittedStockPosition' => 'Eurostop\\Stocks\\SubmittedStockPosition',
      'StockForSku' => 'Eurostop\\Stocks\\StockForSku',
      'ArrayOfStockForSku' => 'Eurostop\\Stocks\\ArrayOfStockForSku',
      'ArrayOfSubmittedDeliveryLine' => 'Eurostop\\Stocks\\ArrayOfSubmittedDeliveryLine',
      'SubmittedDeliveryLine' => 'Eurostop\\Stocks\\SubmittedDeliveryLine',
      'DeliveryHeader' => 'Eurostop\\Stocks\\DeliveryHeader',
      'ArrayOfDeliveryDetail' => 'Eurostop\\Stocks\\ArrayOfDeliveryDetail',
      'DeliveryDetail' => 'Eurostop\\Stocks\\DeliveryDetail',
      'ArrayOfDeliveryHeader' => 'Eurostop\\Stocks\\ArrayOfDeliveryHeader',
      'TransferHeader' => 'Eurostop\\Stocks\\TransferHeader',
      'ArrayOfTransferDetail' => 'Eurostop\\Stocks\\ArrayOfTransferDetail',
      'TransferDetail' => 'Eurostop\\Stocks\\TransferDetail',
      'ArrayOfTransferHeader' => 'Eurostop\\Stocks\\ArrayOfTransferHeader',
      'ArrayOfSubmittedTransferLine' => 'Eurostop\\Stocks\\ArrayOfSubmittedTransferLine',
      'SubmittedTransferLine' => 'Eurostop\\Stocks\\SubmittedTransferLine',
      'ArrayOfSubmittedTillTransferLine' => 'Eurostop\\Stocks\\ArrayOfSubmittedTillTransferLine',
      'SubmittedTillTransferLine' => 'Eurostop\\Stocks\\SubmittedTillTransferLine',
      'PurchaseOrderHeader' => 'Eurostop\\Stocks\\PurchaseOrderHeader',
      'ArrayOfPurchaseOrderDetail' => 'Eurostop\\Stocks\\ArrayOfPurchaseOrderDetail',
      'PurchaseOrderDetail' => 'Eurostop\\Stocks\\PurchaseOrderDetail',
      'ArrayOfPurchaseOrderHeader' => 'Eurostop\\Stocks\\ArrayOfPurchaseOrderHeader',
      'ArrayOfSubmittedPurchaseOrderLine' => 'Eurostop\\Stocks\\ArrayOfSubmittedPurchaseOrderLine',
      'SubmittedPurchaseOrderLine' => 'Eurostop\\Stocks\\SubmittedPurchaseOrderLine',
      'WriteOnOffHeader' => 'Eurostop\\Stocks\\WriteOnOffHeader',
      'ArrayOfWriteOnOffDetail' => 'Eurostop\\Stocks\\ArrayOfWriteOnOffDetail',
      'WriteOnOffDetail' => 'Eurostop\\Stocks\\WriteOnOffDetail',
      'ArrayOfWriteOnOffHeader' => 'Eurostop\\Stocks\\ArrayOfWriteOnOffHeader',
      'ArrayOfSubmittedWriteOnOffLine' => 'Eurostop\\Stocks\\ArrayOfSubmittedWriteOnOffLine',
      'SubmittedWriteOnOffLine' => 'Eurostop\\Stocks\\SubmittedWriteOnOffLine',
      'ArrayOfSubmittedReplenishmentTarget' => 'Eurostop\\Stocks\\ArrayOfSubmittedReplenishmentTarget',
      'SubmittedReplenishmentTarget' => 'Eurostop\\Stocks\\SubmittedReplenishmentTarget',
      'ArrayOfSubmittedSkuReplenishmentCeiling' => 'Eurostop\\Stocks\\ArrayOfSubmittedSkuReplenishmentCeiling',
      'SubmittedSkuReplenishmentCeiling' => 'Eurostop\\Stocks\\SubmittedSkuReplenishmentCeiling',
      'DataRetrievalResultOfStockF65MdnO4' => 'Eurostop\\Stocks\\DataRetrievalResultOfStockF65MdnO4',
      'RetrievedDataItemOfStockPositionDto6qbTdoQx' => 'Eurostop\\Stocks\\RetrievedDataItemOfStockPositionDto6qbTdoQx',
      'SubmittedDataItemOfSubmittedStockPositionDto6qbTdoQx' => 'Eurostop\\Stocks\\SubmittedDataItemOfSubmittedStockPositionDto6qbTdoQx',
      'DataSubmissionResult' => 'Eurostop\\Stocks\\DataSubmissionResult',
      'ArrayOfValidationError' => 'Eurostop\\Stocks\\ArrayOfValidationError',
      'ValidationError' => 'Eurostop\\Stocks\\ValidationError',
      'DataRetrievalResultOfStockForSkuF65MdnO4' => 'Eurostop\\Stocks\\DataRetrievalResultOfStockForSkuF65MdnO4',
      'RetrievedDataItemOfStockPositionForSkuDto6qbTdoQx' => 'Eurostop\\Stocks\\RetrievedDataItemOfStockPositionForSkuDto6qbTdoQx',
      'SubmittedDataItemOfSubmittedDeliveryLineDto6qbTdoQx' => 'Eurostop\\Stocks\\SubmittedDataItemOfSubmittedDeliveryLineDto6qbTdoQx',
      'DataRetrievalResultOfDeliveryHeaderF65MdnO4' => 'Eurostop\\Stocks\\DataRetrievalResultOfDeliveryHeaderF65MdnO4',
      'CodedRetrievedDataItemOfDeliveryHeaderDto6qbTdoQx' => 'Eurostop\\Stocks\\CodedRetrievedDataItemOfDeliveryHeaderDto6qbTdoQx',
      'RetrievedDataItemOfDeliveryHeaderDto6qbTdoQx' => 'Eurostop\\Stocks\\RetrievedDataItemOfDeliveryHeaderDto6qbTdoQx',
      'RetrievedDataItemOfDeliveryDetailDto6qbTdoQx' => 'Eurostop\\Stocks\\RetrievedDataItemOfDeliveryDetailDto6qbTdoQx',
      'DataRetrievalResultOfTransferHeaderF65MdnO4' => 'Eurostop\\Stocks\\DataRetrievalResultOfTransferHeaderF65MdnO4',
      'CodedRetrievedDataItemOfTransferHeaderDto6qbTdoQx' => 'Eurostop\\Stocks\\CodedRetrievedDataItemOfTransferHeaderDto6qbTdoQx',
      'RetrievedDataItemOfTransferHeaderDto6qbTdoQx' => 'Eurostop\\Stocks\\RetrievedDataItemOfTransferHeaderDto6qbTdoQx',
      'RetrievedDataItemOfTransferDetailDto6qbTdoQx' => 'Eurostop\\Stocks\\RetrievedDataItemOfTransferDetailDto6qbTdoQx',
      'SubmittedDataItemOfSubmittedTransferLineDto6qbTdoQx' => 'Eurostop\\Stocks\\SubmittedDataItemOfSubmittedTransferLineDto6qbTdoQx',
      'SubmittedDataItemOfSubmittedTillTransferLineDto6qbTdoQx' => 'Eurostop\\Stocks\\SubmittedDataItemOfSubmittedTillTransferLineDto6qbTdoQx',
      'DataRetrievalResultOfPurchaseOrderHeaderF65MdnO4' => 'Eurostop\\Stocks\\DataRetrievalResultOfPurchaseOrderHeaderF65MdnO4',
      'CodedRetrievedDataItemOfPurchaseOrderHeaderDto6qbTdoQx' => 'Eurostop\\Stocks\\CodedRetrievedDataItemOfPurchaseOrderHeaderDto6qbTdoQx',
      'RetrievedDataItemOfPurchaseOrderHeaderDto6qbTdoQx' => 'Eurostop\\Stocks\\RetrievedDataItemOfPurchaseOrderHeaderDto6qbTdoQx',
      'RetrievedDataItemOfPurchaseOrderDetailDto6qbTdoQx' => 'Eurostop\\Stocks\\RetrievedDataItemOfPurchaseOrderDetailDto6qbTdoQx',
      'SubmittedDataItemOfSubmittedPurchaseOrderLineDto6qbTdoQx' => 'Eurostop\\Stocks\\SubmittedDataItemOfSubmittedPurchaseOrderLineDto6qbTdoQx',
      'DataRetrievalResultOfWriteOnOffHeaderF65MdnO4' => 'Eurostop\\Stocks\\DataRetrievalResultOfWriteOnOffHeaderF65MdnO4',
      'CodedRetrievedDataItemOfWriteOnOffHeaderDto6qbTdoQx' => 'Eurostop\\Stocks\\CodedRetrievedDataItemOfWriteOnOffHeaderDto6qbTdoQx',
      'RetrievedDataItemOfWriteOnOffHeaderDto6qbTdoQx' => 'Eurostop\\Stocks\\RetrievedDataItemOfWriteOnOffHeaderDto6qbTdoQx',
      'RetrievedDataItemOfWriteOnOffDetailDto6qbTdoQx' => 'Eurostop\\Stocks\\RetrievedDataItemOfWriteOnOffDetailDto6qbTdoQx',
      'SubmittedDataItemOfSubmittedWriteOnOffLineDto6qbTdoQx' => 'Eurostop\\Stocks\\SubmittedDataItemOfSubmittedWriteOnOffLineDto6qbTdoQx',
      'SubmittedDataItemOfSubmittedReplenishmentTargetDto6qbTdoQx' => 'Eurostop\\Stocks\\SubmittedDataItemOfSubmittedReplenishmentTargetDto6qbTdoQx',
      'SubmittedDataItemOfSubmittedSkuReplenishmentCeilingDto6qbTdoQx' => 'Eurostop\\Stocks\\SubmittedDataItemOfSubmittedSkuReplenishmentCeilingDto6qbTdoQx',
      'ArrayOfDataProcessingResult' => 'Eurostop\\Stocks\\ArrayOfDataProcessingResult',
      'DataProcessingResult' => 'Eurostop\\Stocks\\DataProcessingResult',
      'ArrayOfDataProcessingStatus' => 'Eurostop\\Stocks\\ArrayOfDataProcessingStatus',
      'DataProcessingStatus' => 'Eurostop\\Stocks\\DataProcessingStatus',
      'ArrayOfstring' => 'Eurostop\\Stocks\\ArrayOfstring',
      'GetCurrentStockPositionByBranch' => 'Eurostop\\Stocks\\GetCurrentStockPositionByBranch',
      'GetCurrentStockPositionByBranchResponse' => 'Eurostop\\Stocks\\GetCurrentStockPositionByBranchResponse',
      'GetCurrentStockPositionByBranchAndSku' => 'Eurostop\\Stocks\\GetCurrentStockPositionByBranchAndSku',
      'GetCurrentStockPositionByBranchAndSkuResponse' => 'Eurostop\\Stocks\\GetCurrentStockPositionByBranchAndSkuResponse',
      'GetCurrentStockPositionByBranchAndHierarchyNode' => 'Eurostop\\Stocks\\GetCurrentStockPositionByBranchAndHierarchyNode',
      'GetCurrentStockPositionByBranchAndHierarchyNodeResponse' => 'Eurostop\\Stocks\\GetCurrentStockPositionByBranchAndHierarchyNodeResponse',
      'GetCurrentStockPositionByBranchAndProduct' => 'Eurostop\\Stocks\\GetCurrentStockPositionByBranchAndProduct',
      'GetCurrentStockPositionByBranchAndProductResponse' => 'Eurostop\\Stocks\\GetCurrentStockPositionByBranchAndProductResponse',
      'GetCurrentStockPositionBySku' => 'Eurostop\\Stocks\\GetCurrentStockPositionBySku',
      'GetCurrentStockPositionBySkuResponse' => 'Eurostop\\Stocks\\GetCurrentStockPositionBySkuResponse',
      'GetCurrentStockPositionByHierarchyNode' => 'Eurostop\\Stocks\\GetCurrentStockPositionByHierarchyNode',
      'GetCurrentStockPositionByHierarchyNodeResponse' => 'Eurostop\\Stocks\\GetCurrentStockPositionByHierarchyNodeResponse',
      'GetCurrentStockPositionByProduct' => 'Eurostop\\Stocks\\GetCurrentStockPositionByProduct',
      'GetCurrentStockPositionByProductResponse' => 'Eurostop\\Stocks\\GetCurrentStockPositionByProductResponse',
      'GetCurrentStockPositionByBranchGroup' => 'Eurostop\\Stocks\\GetCurrentStockPositionByBranchGroup',
      'GetCurrentStockPositionByBranchGroupResponse' => 'Eurostop\\Stocks\\GetCurrentStockPositionByBranchGroupResponse',
      'GetCurrentStockPositionByBranchGroupAndProduct' => 'Eurostop\\Stocks\\GetCurrentStockPositionByBranchGroupAndProduct',
      'GetCurrentStockPositionByBranchGroupAndProductResponse' => 'Eurostop\\Stocks\\GetCurrentStockPositionByBranchGroupAndProductResponse',
      'GetCurrentStockPositionByBranchGroupAndSku' => 'Eurostop\\Stocks\\GetCurrentStockPositionByBranchGroupAndSku',
      'GetCurrentStockPositionByBranchGroupAndSkuResponse' => 'Eurostop\\Stocks\\GetCurrentStockPositionByBranchGroupAndSkuResponse',
      'GetCurrentStockPositionByBranchGroupAndProductList' => 'Eurostop\\Stocks\\GetCurrentStockPositionByBranchGroupAndProductList',
      'GetCurrentStockPositionByBranchGroupAndProductListResponse' => 'Eurostop\\Stocks\\GetCurrentStockPositionByBranchGroupAndProductListResponse',
      'GetCurrentStockPositionByBranchAndProductList' => 'Eurostop\\Stocks\\GetCurrentStockPositionByBranchAndProductList',
      'GetCurrentStockPositionByBranchAndProductListResponse' => 'Eurostop\\Stocks\\GetCurrentStockPositionByBranchAndProductListResponse',
      'GetCurrentStockPositionByBranchGroupAndSkuList' => 'Eurostop\\Stocks\\GetCurrentStockPositionByBranchGroupAndSkuList',
      'GetCurrentStockPositionByBranchGroupAndSkuListResponse' => 'Eurostop\\Stocks\\GetCurrentStockPositionByBranchGroupAndSkuListResponse',
      'GetCurrentStockPositionByBranchAndSkuList' => 'Eurostop\\Stocks\\GetCurrentStockPositionByBranchAndSkuList',
      'GetCurrentStockPositionByBranchAndSkuListResponse' => 'Eurostop\\Stocks\\GetCurrentStockPositionByBranchAndSkuListResponse',
      'SubmitNewStockPositions' => 'Eurostop\\Stocks\\SubmitNewStockPositions',
      'SubmitNewStockPositionsResponse' => 'Eurostop\\Stocks\\SubmitNewStockPositionsResponse',
      'GetCurrentSkuStockByBranch' => 'Eurostop\\Stocks\\GetCurrentSkuStockByBranch',
      'GetCurrentSkuStockByBranchResponse' => 'Eurostop\\Stocks\\GetCurrentSkuStockByBranchResponse',
      'GetCurrentSkuStockByBranchAndSku' => 'Eurostop\\Stocks\\GetCurrentSkuStockByBranchAndSku',
      'GetCurrentSkuStockByBranchAndSkuResponse' => 'Eurostop\\Stocks\\GetCurrentSkuStockByBranchAndSkuResponse',
      'GetCurrentSkuStockByBranchAndHierarchyNode' => 'Eurostop\\Stocks\\GetCurrentSkuStockByBranchAndHierarchyNode',
      'GetCurrentSkuStockByBranchAndHierarchyNodeResponse' => 'Eurostop\\Stocks\\GetCurrentSkuStockByBranchAndHierarchyNodeResponse',
      'GetCurrentSkuStockByBranchAndProduct' => 'Eurostop\\Stocks\\GetCurrentSkuStockByBranchAndProduct',
      'GetCurrentSkuStockByBranchAndProductResponse' => 'Eurostop\\Stocks\\GetCurrentSkuStockByBranchAndProductResponse',
      'GetCurrentSkuStockBySku' => 'Eurostop\\Stocks\\GetCurrentSkuStockBySku',
      'GetCurrentSkuStockBySkuResponse' => 'Eurostop\\Stocks\\GetCurrentSkuStockBySkuResponse',
      'GetCurrentSkuStockByHierarchyNode' => 'Eurostop\\Stocks\\GetCurrentSkuStockByHierarchyNode',
      'GetCurrentSkuStockByHierarchyNodeResponse' => 'Eurostop\\Stocks\\GetCurrentSkuStockByHierarchyNodeResponse',
      'GetCurrentSkuStockByProduct' => 'Eurostop\\Stocks\\GetCurrentSkuStockByProduct',
      'GetCurrentSkuStockByProductResponse' => 'Eurostop\\Stocks\\GetCurrentSkuStockByProductResponse',
      'GetCurrentSkuStockByBranchGroup' => 'Eurostop\\Stocks\\GetCurrentSkuStockByBranchGroup',
      'GetCurrentSkuStockByBranchGroupResponse' => 'Eurostop\\Stocks\\GetCurrentSkuStockByBranchGroupResponse',
      'GetCurrentSkuStockByBranchGroupAndProduct' => 'Eurostop\\Stocks\\GetCurrentSkuStockByBranchGroupAndProduct',
      'GetCurrentSkuStockByBranchGroupAndProductResponse' => 'Eurostop\\Stocks\\GetCurrentSkuStockByBranchGroupAndProductResponse',
      'GetCurrentSkuStockByBranchGroupAndSku' => 'Eurostop\\Stocks\\GetCurrentSkuStockByBranchGroupAndSku',
      'GetCurrentSkuStockByBranchGroupAndSkuResponse' => 'Eurostop\\Stocks\\GetCurrentSkuStockByBranchGroupAndSkuResponse',
      'GetCurrentSkuStockByBranchGroupAndProductList' => 'Eurostop\\Stocks\\GetCurrentSkuStockByBranchGroupAndProductList',
      'GetCurrentSkuStockByBranchGroupAndProductListResponse' => 'Eurostop\\Stocks\\GetCurrentSkuStockByBranchGroupAndProductListResponse',
      'GetCurrentSkuStockByBranchAndProductList' => 'Eurostop\\Stocks\\GetCurrentSkuStockByBranchAndProductList',
      'GetCurrentSkuStockByBranchAndProductListResponse' => 'Eurostop\\Stocks\\GetCurrentSkuStockByBranchAndProductListResponse',
      'GetCurrentSkuStockByBranchGroupAndSkuList' => 'Eurostop\\Stocks\\GetCurrentSkuStockByBranchGroupAndSkuList',
      'GetCurrentSkuStockByBranchGroupAndSkuListResponse' => 'Eurostop\\Stocks\\GetCurrentSkuStockByBranchGroupAndSkuListResponse',
      'GetCurrentSkuStockByBranchAndSkuList' => 'Eurostop\\Stocks\\GetCurrentSkuStockByBranchAndSkuList',
      'GetCurrentSkuStockByBranchAndSkuListResponse' => 'Eurostop\\Stocks\\GetCurrentSkuStockByBranchAndSkuListResponse',
      'SubmitDeliveries' => 'Eurostop\\Stocks\\SubmitDeliveries',
      'SubmitDeliveriesResponse' => 'Eurostop\\Stocks\\SubmitDeliveriesResponse',
      'GetDeliveriesByWarehouse' => 'Eurostop\\Stocks\\GetDeliveriesByWarehouse',
      'GetDeliveriesByWarehouseResponse' => 'Eurostop\\Stocks\\GetDeliveriesByWarehouseResponse',
      'GetDeliveriesByWarehouseAndDate' => 'Eurostop\\Stocks\\GetDeliveriesByWarehouseAndDate',
      'GetDeliveriesByWarehouseAndDateResponse' => 'Eurostop\\Stocks\\GetDeliveriesByWarehouseAndDateResponse',
      'GetDeliveriesByDates' => 'Eurostop\\Stocks\\GetDeliveriesByDates',
      'GetDeliveriesByDatesResponse' => 'Eurostop\\Stocks\\GetDeliveriesByDatesResponse',
      'GetDeliveryByIdentifier' => 'Eurostop\\Stocks\\GetDeliveryByIdentifier',
      'GetDeliveryByIdentifierResponse' => 'Eurostop\\Stocks\\GetDeliveryByIdentifierResponse',
      'GetDeliveriesByPurchaseOrder' => 'Eurostop\\Stocks\\GetDeliveriesByPurchaseOrder',
      'GetDeliveriesByPurchaseOrderResponse' => 'Eurostop\\Stocks\\GetDeliveriesByPurchaseOrderResponse',
      'GetConsolidatedTransfersByBranchTransferDate' => 'Eurostop\\Stocks\\GetConsolidatedTransfersByBranchTransferDate',
      'GetConsolidatedTransfersByBranchTransferDateResponse' => 'Eurostop\\Stocks\\GetConsolidatedTransfersByBranchTransferDateResponse',
      'GetConsolidatedTransfersByTransferDate' => 'Eurostop\\Stocks\\GetConsolidatedTransfersByTransferDate',
      'GetConsolidatedTransfersByTransferDateResponse' => 'Eurostop\\Stocks\\GetConsolidatedTransfersByTransferDateResponse',
      'GetConsolidatedTransferByIdentifier' => 'Eurostop\\Stocks\\GetConsolidatedTransferByIdentifier',
      'GetConsolidatedTransferByIdentifierResponse' => 'Eurostop\\Stocks\\GetConsolidatedTransferByIdentifierResponse',
      'GetInOutTransfersByBranchTransferDate' => 'Eurostop\\Stocks\\GetInOutTransfersByBranchTransferDate',
      'GetInOutTransfersByBranchTransferDateResponse' => 'Eurostop\\Stocks\\GetInOutTransfersByBranchTransferDateResponse',
      'GetInOutTransfersByTransferDate' => 'Eurostop\\Stocks\\GetInOutTransfersByTransferDate',
      'GetInOutTransfersByTransferDateResponse' => 'Eurostop\\Stocks\\GetInOutTransfersByTransferDateResponse',
      'GetInOutTransferByIdentifier' => 'Eurostop\\Stocks\\GetInOutTransferByIdentifier',
      'GetInOutTransferByIdentifierResponse' => 'Eurostop\\Stocks\\GetInOutTransferByIdentifierResponse',
      'ConfirmTransfer' => 'Eurostop\\Stocks\\ConfirmTransfer',
      'ConfirmTransferResponse' => 'Eurostop\\Stocks\\ConfirmTransferResponse',
      'ConfirmTransfers' => 'Eurostop\\Stocks\\ConfirmTransfers',
      'ConfirmTransfersResponse' => 'Eurostop\\Stocks\\ConfirmTransfersResponse',
      'SubmitTransfers' => 'Eurostop\\Stocks\\SubmitTransfers',
      'SubmitTransfersResponse' => 'Eurostop\\Stocks\\SubmitTransfersResponse',
      'SubmitTillTransfers' => 'Eurostop\\Stocks\\SubmitTillTransfers',
      'SubmitTillTransfersResponse' => 'Eurostop\\Stocks\\SubmitTillTransfersResponse',
      'GetPurchaseOrdersByIdentifier' => 'Eurostop\\Stocks\\GetPurchaseOrdersByIdentifier',
      'GetPurchaseOrdersByIdentifierResponse' => 'Eurostop\\Stocks\\GetPurchaseOrdersByIdentifierResponse',
      'GetPurchaseOrdersByDate' => 'Eurostop\\Stocks\\GetPurchaseOrdersByDate',
      'GetPurchaseOrdersByDateResponse' => 'Eurostop\\Stocks\\GetPurchaseOrdersByDateResponse',
      'GetPurchaseOrdersByWarehouse' => 'Eurostop\\Stocks\\GetPurchaseOrdersByWarehouse',
      'GetPurchaseOrdersByWarehouseResponse' => 'Eurostop\\Stocks\\GetPurchaseOrdersByWarehouseResponse',
      'GetPurchaseOrdersByWarehouseAndDate' => 'Eurostop\\Stocks\\GetPurchaseOrdersByWarehouseAndDate',
      'GetPurchaseOrdersByWarehouseAndDateResponse' => 'Eurostop\\Stocks\\GetPurchaseOrdersByWarehouseAndDateResponse',
      'ConfirmPurchaseOrder' => 'Eurostop\\Stocks\\ConfirmPurchaseOrder',
      'ConfirmPurchaseOrderResponse' => 'Eurostop\\Stocks\\ConfirmPurchaseOrderResponse',
      'ConfirmPurchaseOrders' => 'Eurostop\\Stocks\\ConfirmPurchaseOrders',
      'ConfirmPurchaseOrdersResponse' => 'Eurostop\\Stocks\\ConfirmPurchaseOrdersResponse',
      'CancelPurchaseOrder' => 'Eurostop\\Stocks\\CancelPurchaseOrder',
      'CancelPurchaseOrderResponse' => 'Eurostop\\Stocks\\CancelPurchaseOrderResponse',
      'SubmitPurchaseOrders' => 'Eurostop\\Stocks\\SubmitPurchaseOrders',
      'SubmitPurchaseOrdersResponse' => 'Eurostop\\Stocks\\SubmitPurchaseOrdersResponse',
      'GetWriteOnOffsByBranchDate' => 'Eurostop\\Stocks\\GetWriteOnOffsByBranchDate',
      'GetWriteOnOffsByBranchDateResponse' => 'Eurostop\\Stocks\\GetWriteOnOffsByBranchDateResponse',
      'GetWriteOnOffsByDate' => 'Eurostop\\Stocks\\GetWriteOnOffsByDate',
      'GetWriteOnOffsByDateResponse' => 'Eurostop\\Stocks\\GetWriteOnOffsByDateResponse',
      'GetWriteOnOffByIdentifier' => 'Eurostop\\Stocks\\GetWriteOnOffByIdentifier',
      'GetWriteOnOffByIdentifierResponse' => 'Eurostop\\Stocks\\GetWriteOnOffByIdentifierResponse',
      'SubmitWriteOnOffs' => 'Eurostop\\Stocks\\SubmitWriteOnOffs',
      'SubmitWriteOnOffsResponse' => 'Eurostop\\Stocks\\SubmitWriteOnOffsResponse',
      'SubmitReplenishmentTargets' => 'Eurostop\\Stocks\\SubmitReplenishmentTargets',
      'SubmitReplenishmentTargetsResponse' => 'Eurostop\\Stocks\\SubmitReplenishmentTargetsResponse',
      'SubmitSkuReplenishmentCeilings' => 'Eurostop\\Stocks\\SubmitSkuReplenishmentCeilings',
      'SubmitSkuReplenishmentCeilingsResponse' => 'Eurostop\\Stocks\\SubmitSkuReplenishmentCeilingsResponse',
      'FlagDataProcessingToRetryByReference' => 'Eurostop\\Stocks\\FlagDataProcessingToRetryByReference',
      'FlagDataProcessingToRetryByReferenceResponse' => 'Eurostop\\Stocks\\FlagDataProcessingToRetryByReferenceResponse',
      'FlagDataProcessingToRetryByToken' => 'Eurostop\\Stocks\\FlagDataProcessingToRetryByToken',
      'FlagDataProcessingToRetryByTokenResponse' => 'Eurostop\\Stocks\\FlagDataProcessingToRetryByTokenResponse',
      'RunDataProcessingByReference' => 'Eurostop\\Stocks\\RunDataProcessingByReference',
      'RunDataProcessingByReferenceResponse' => 'Eurostop\\Stocks\\RunDataProcessingByReferenceResponse',
      'RunDataProcessingByToken' => 'Eurostop\\Stocks\\RunDataProcessingByToken',
      'RunDataProcessingByTokenResponse' => 'Eurostop\\Stocks\\RunDataProcessingByTokenResponse',
    );

    /**
     * @param array $options A array of config values
     * @param string $wsdl The wsdl file to use
     */
    public function __construct(array $options = array(), $wsdl = null)
    {
      foreach (self::$classmap as $key => $value) {
        if (!isset($options['classmap'][$key])) {
          $options['classmap'][$key] = $value;
        }
      }
      $options = array_merge(array (
      'stream_context' => NULL,
      'features' => 1,
    ), $options);
      if (!$wsdl) {
        $wsdl = 'https://retailtest.trotters.co.uk:6500/e-interface/stocks?wsdl';
      }
      parent::__construct($wsdl, $options);
    }

    /**
     * @param GetCurrentStockPositionByBranch $parameters
     * @return GetCurrentStockPositionByBranchResponse
     */
    public function GetCurrentStockPositionByBranch(GetCurrentStockPositionByBranch $parameters)
    {
      return $this->__soapCall('GetCurrentStockPositionByBranch', array($parameters));
    }

    /**
     * @param GetCurrentStockPositionByBranchAndSku $parameters
     * @return GetCurrentStockPositionByBranchAndSkuResponse
     */
    public function GetCurrentStockPositionByBranchAndSku(GetCurrentStockPositionByBranchAndSku $parameters)
    {
      return $this->__soapCall('GetCurrentStockPositionByBranchAndSku', array($parameters));
    }

    /**
     * @param GetCurrentStockPositionByBranchAndHierarchyNode $parameters
     * @return GetCurrentStockPositionByBranchAndHierarchyNodeResponse
     */
    public function GetCurrentStockPositionByBranchAndHierarchyNode(GetCurrentStockPositionByBranchAndHierarchyNode $parameters)
    {
      return $this->__soapCall('GetCurrentStockPositionByBranchAndHierarchyNode', array($parameters));
    }

    /**
     * @param GetCurrentStockPositionByBranchAndProduct $parameters
     * @return GetCurrentStockPositionByBranchAndProductResponse
     */
    public function GetCurrentStockPositionByBranchAndProduct(GetCurrentStockPositionByBranchAndProduct $parameters)
    {
      return $this->__soapCall('GetCurrentStockPositionByBranchAndProduct', array($parameters));
    }

    /**
     * @param GetCurrentStockPositionBySku $parameters
     * @return GetCurrentStockPositionBySkuResponse
     */
    public function GetCurrentStockPositionBySku(GetCurrentStockPositionBySku $parameters)
    {
      return $this->__soapCall('GetCurrentStockPositionBySku', array($parameters));
    }

    /**
     * @param GetCurrentStockPositionByHierarchyNode $parameters
     * @return GetCurrentStockPositionByHierarchyNodeResponse
     */
    public function GetCurrentStockPositionByHierarchyNode(GetCurrentStockPositionByHierarchyNode $parameters)
    {
      return $this->__soapCall('GetCurrentStockPositionByHierarchyNode', array($parameters));
    }

    /**
     * @param GetCurrentStockPositionByProduct $parameters
     * @return GetCurrentStockPositionByProductResponse
     */
    public function GetCurrentStockPositionByProduct(GetCurrentStockPositionByProduct $parameters)
    {
      return $this->__soapCall('GetCurrentStockPositionByProduct', array($parameters));
    }

    /**
     * @param GetCurrentStockPositionByBranchGroup $parameters
     * @return GetCurrentStockPositionByBranchGroupResponse
     */
    public function GetCurrentStockPositionByBranchGroup(GetCurrentStockPositionByBranchGroup $parameters)
    {
      return $this->__soapCall('GetCurrentStockPositionByBranchGroup', array($parameters));
    }

    /**
     * @param GetCurrentStockPositionByBranchGroupAndProduct $parameters
     * @return GetCurrentStockPositionByBranchGroupAndProductResponse
     */
    public function GetCurrentStockPositionByBranchGroupAndProduct(GetCurrentStockPositionByBranchGroupAndProduct $parameters)
    {
      return $this->__soapCall('GetCurrentStockPositionByBranchGroupAndProduct', array($parameters));
    }

    /**
     * @param GetCurrentStockPositionByBranchGroupAndSku $parameters
     * @return GetCurrentStockPositionByBranchGroupAndSkuResponse
     */
    public function GetCurrentStockPositionByBranchGroupAndSku(GetCurrentStockPositionByBranchGroupAndSku $parameters)
    {
      return $this->__soapCall('GetCurrentStockPositionByBranchGroupAndSku', array($parameters));
    }

    /**
     * @param GetCurrentStockPositionByBranchGroupAndProductList $parameters
     * @return GetCurrentStockPositionByBranchGroupAndProductListResponse
     */
    public function GetCurrentStockPositionByBranchGroupAndProductList(GetCurrentStockPositionByBranchGroupAndProductList $parameters)
    {
      return $this->__soapCall('GetCurrentStockPositionByBranchGroupAndProductList', array($parameters));
    }

    /**
     * @param GetCurrentStockPositionByBranchAndProductList $parameters
     * @return GetCurrentStockPositionByBranchAndProductListResponse
     */
    public function GetCurrentStockPositionByBranchAndProductList(GetCurrentStockPositionByBranchAndProductList $parameters)
    {
      return $this->__soapCall('GetCurrentStockPositionByBranchAndProductList', array($parameters));
    }

    /**
     * @param GetCurrentStockPositionByBranchGroupAndSkuList $parameters
     * @return GetCurrentStockPositionByBranchGroupAndSkuListResponse
     */
    public function GetCurrentStockPositionByBranchGroupAndSkuList(GetCurrentStockPositionByBranchGroupAndSkuList $parameters)
    {
      return $this->__soapCall('GetCurrentStockPositionByBranchGroupAndSkuList', array($parameters));
    }

    /**
     * @param GetCurrentStockPositionByBranchAndSkuList $parameters
     * @return GetCurrentStockPositionByBranchAndSkuListResponse
     */
    public function GetCurrentStockPositionByBranchAndSkuList(GetCurrentStockPositionByBranchAndSkuList $parameters)
    {
      return $this->__soapCall('GetCurrentStockPositionByBranchAndSkuList', array($parameters));
    }

    /**
     * @param SubmitNewStockPositions $parameters
     * @return SubmitNewStockPositionsResponse
     */
    public function SubmitNewStockPositions(SubmitNewStockPositions $parameters)
    {
      return $this->__soapCall('SubmitNewStockPositions', array($parameters));
    }

    /**
     * @param GetCurrentSkuStockByBranch $parameters
     * @return GetCurrentSkuStockByBranchResponse
     */
    public function GetCurrentSkuStockByBranch(GetCurrentSkuStockByBranch $parameters)
    {
      return $this->__soapCall('GetCurrentSkuStockByBranch', array($parameters));
    }

    /**
     * @param GetCurrentSkuStockByBranchAndSku $parameters
     * @return GetCurrentSkuStockByBranchAndSkuResponse
     */
    public function GetCurrentSkuStockByBranchAndSku(GetCurrentSkuStockByBranchAndSku $parameters)
    {
      return $this->__soapCall('GetCurrentSkuStockByBranchAndSku', array($parameters));
    }

    /**
     * @param GetCurrentSkuStockByBranchAndHierarchyNode $parameters
     * @return GetCurrentSkuStockByBranchAndHierarchyNodeResponse
     */
    public function GetCurrentSkuStockByBranchAndHierarchyNode(GetCurrentSkuStockByBranchAndHierarchyNode $parameters)
    {
      return $this->__soapCall('GetCurrentSkuStockByBranchAndHierarchyNode', array($parameters));
    }

    /**
     * @param GetCurrentSkuStockByBranchAndProduct $parameters
     * @return GetCurrentSkuStockByBranchAndProductResponse
     */
    public function GetCurrentSkuStockByBranchAndProduct(GetCurrentSkuStockByBranchAndProduct $parameters)
    {
      return $this->__soapCall('GetCurrentSkuStockByBranchAndProduct', array($parameters));
    }

    /**
     * @param GetCurrentSkuStockBySku $parameters
     * @return GetCurrentSkuStockBySkuResponse
     */
    public function GetCurrentSkuStockBySku(GetCurrentSkuStockBySku $parameters)
    {
      return $this->__soapCall('GetCurrentSkuStockBySku', array($parameters));
    }

    /**
     * @param GetCurrentSkuStockByHierarchyNode $parameters
     * @return GetCurrentSkuStockByHierarchyNodeResponse
     */
    public function GetCurrentSkuStockByHierarchyNode(GetCurrentSkuStockByHierarchyNode $parameters)
    {
      return $this->__soapCall('GetCurrentSkuStockByHierarchyNode', array($parameters));
    }

    /**
     * @param GetCurrentSkuStockByProduct $parameters
     * @return GetCurrentSkuStockByProductResponse
     */
    public function GetCurrentSkuStockByProduct(GetCurrentSkuStockByProduct $parameters)
    {
      return $this->__soapCall('GetCurrentSkuStockByProduct', array($parameters));
    }

    /**
     * @param GetCurrentSkuStockByBranchGroup $parameters
     * @return GetCurrentSkuStockByBranchGroupResponse
     */
    public function GetCurrentSkuStockByBranchGroup(GetCurrentSkuStockByBranchGroup $parameters)
    {
      return $this->__soapCall('GetCurrentSkuStockByBranchGroup', array($parameters));
    }

    /**
     * @param GetCurrentSkuStockByBranchGroupAndProduct $parameters
     * @return GetCurrentSkuStockByBranchGroupAndProductResponse
     */
    public function GetCurrentSkuStockByBranchGroupAndProduct(GetCurrentSkuStockByBranchGroupAndProduct $parameters)
    {
      return $this->__soapCall('GetCurrentSkuStockByBranchGroupAndProduct', array($parameters));
    }

    /**
     * @param GetCurrentSkuStockByBranchGroupAndSku $parameters
     * @return GetCurrentSkuStockByBranchGroupAndSkuResponse
     */
    public function GetCurrentSkuStockByBranchGroupAndSku(GetCurrentSkuStockByBranchGroupAndSku $parameters)
    {
      return $this->__soapCall('GetCurrentSkuStockByBranchGroupAndSku', array($parameters));
    }

    /**
     * @param GetCurrentSkuStockByBranchGroupAndProductList $parameters
     * @return GetCurrentSkuStockByBranchGroupAndProductListResponse
     */
    public function GetCurrentSkuStockByBranchGroupAndProductList(GetCurrentSkuStockByBranchGroupAndProductList $parameters)
    {
      return $this->__soapCall('GetCurrentSkuStockByBranchGroupAndProductList', array($parameters));
    }

    /**
     * @param GetCurrentSkuStockByBranchAndProductList $parameters
     * @return GetCurrentSkuStockByBranchAndProductListResponse
     */
    public function GetCurrentSkuStockByBranchAndProductList(GetCurrentSkuStockByBranchAndProductList $parameters)
    {
      return $this->__soapCall('GetCurrentSkuStockByBranchAndProductList', array($parameters));
    }

    /**
     * @param GetCurrentSkuStockByBranchGroupAndSkuList $parameters
     * @return GetCurrentSkuStockByBranchGroupAndSkuListResponse
     */
    public function GetCurrentSkuStockByBranchGroupAndSkuList(GetCurrentSkuStockByBranchGroupAndSkuList $parameters)
    {
      return $this->__soapCall('GetCurrentSkuStockByBranchGroupAndSkuList', array($parameters));
    }

    /**
     * @param GetCurrentSkuStockByBranchAndSkuList $parameters
     * @return GetCurrentSkuStockByBranchAndSkuListResponse
     */
    public function GetCurrentSkuStockByBranchAndSkuList(GetCurrentSkuStockByBranchAndSkuList $parameters)
    {
      return $this->__soapCall('GetCurrentSkuStockByBranchAndSkuList', array($parameters));
    }

    /**
     * @param SubmitDeliveries $parameters
     * @return SubmitDeliveriesResponse
     */
    public function SubmitDeliveries(SubmitDeliveries $parameters)
    {
      return $this->__soapCall('SubmitDeliveries', array($parameters));
    }

    /**
     * @param GetDeliveriesByWarehouse $parameters
     * @return GetDeliveriesByWarehouseResponse
     */
    public function GetDeliveriesByWarehouse(GetDeliveriesByWarehouse $parameters)
    {
      return $this->__soapCall('GetDeliveriesByWarehouse', array($parameters));
    }

    /**
     * @param GetDeliveriesByWarehouseAndDate $parameters
     * @return GetDeliveriesByWarehouseAndDateResponse
     */
    public function GetDeliveriesByWarehouseAndDate(GetDeliveriesByWarehouseAndDate $parameters)
    {
      return $this->__soapCall('GetDeliveriesByWarehouseAndDate', array($parameters));
    }

    /**
     * @param GetDeliveriesByDates $parameters
     * @return GetDeliveriesByDatesResponse
     */
    public function GetDeliveriesByDates(GetDeliveriesByDates $parameters)
    {
      return $this->__soapCall('GetDeliveriesByDates', array($parameters));
    }

    /**
     * @param GetDeliveryByIdentifier $parameters
     * @return GetDeliveryByIdentifierResponse
     */
    public function GetDeliveryByIdentifier(GetDeliveryByIdentifier $parameters)
    {
      return $this->__soapCall('GetDeliveryByIdentifier', array($parameters));
    }

    /**
     * @param GetDeliveriesByPurchaseOrder $parameters
     * @return GetDeliveriesByPurchaseOrderResponse
     */
    public function GetDeliveriesByPurchaseOrder(GetDeliveriesByPurchaseOrder $parameters)
    {
      return $this->__soapCall('GetDeliveriesByPurchaseOrder', array($parameters));
    }

    /**
     * @param GetConsolidatedTransfersByBranchTransferDate $parameters
     * @return GetConsolidatedTransfersByBranchTransferDateResponse
     */
    public function GetConsolidatedTransfersByBranchTransferDate(GetConsolidatedTransfersByBranchTransferDate $parameters)
    {
      return $this->__soapCall('GetConsolidatedTransfersByBranchTransferDate', array($parameters));
    }

    /**
     * @param GetConsolidatedTransfersByTransferDate $parameters
     * @return GetConsolidatedTransfersByTransferDateResponse
     */
    public function GetConsolidatedTransfersByTransferDate(GetConsolidatedTransfersByTransferDate $parameters)
    {
      return $this->__soapCall('GetConsolidatedTransfersByTransferDate', array($parameters));
    }

    /**
     * @param GetConsolidatedTransferByIdentifier $parameters
     * @return GetConsolidatedTransferByIdentifierResponse
     */
    public function GetConsolidatedTransferByIdentifier(GetConsolidatedTransferByIdentifier $parameters)
    {
      return $this->__soapCall('GetConsolidatedTransferByIdentifier', array($parameters));
    }

    /**
     * @param GetInOutTransfersByBranchTransferDate $parameters
     * @return GetInOutTransfersByBranchTransferDateResponse
     */
    public function GetInOutTransfersByBranchTransferDate(GetInOutTransfersByBranchTransferDate $parameters)
    {
      return $this->__soapCall('GetInOutTransfersByBranchTransferDate', array($parameters));
    }

    /**
     * @param GetInOutTransfersByTransferDate $parameters
     * @return GetInOutTransfersByTransferDateResponse
     */
    public function GetInOutTransfersByTransferDate(GetInOutTransfersByTransferDate $parameters)
    {
      return $this->__soapCall('GetInOutTransfersByTransferDate', array($parameters));
    }

    /**
     * @param GetInOutTransferByIdentifier $parameters
     * @return GetInOutTransferByIdentifierResponse
     */
    public function GetInOutTransferByIdentifier(GetInOutTransferByIdentifier $parameters)
    {
      return $this->__soapCall('GetInOutTransferByIdentifier', array($parameters));
    }

    /**
     * @param ConfirmTransfer $parameters
     * @return ConfirmTransferResponse
     */
    public function ConfirmTransfer(ConfirmTransfer $parameters)
    {
      return $this->__soapCall('ConfirmTransfer', array($parameters));
    }

    /**
     * @param ConfirmTransfers $parameters
     * @return ConfirmTransfersResponse
     */
    public function ConfirmTransfers(ConfirmTransfers $parameters)
    {
      return $this->__soapCall('ConfirmTransfers', array($parameters));
    }

    /**
     * @param SubmitTransfers $parameters
     * @return SubmitTransfersResponse
     */
    public function SubmitTransfers(SubmitTransfers $parameters)
    {
      return $this->__soapCall('SubmitTransfers', array($parameters));
    }

    /**
     * @param SubmitTillTransfers $parameters
     * @return SubmitTillTransfersResponse
     */
    public function SubmitTillTransfers(SubmitTillTransfers $parameters)
    {
      return $this->__soapCall('SubmitTillTransfers', array($parameters));
    }

    /**
     * @param GetPurchaseOrdersByIdentifier $parameters
     * @return GetPurchaseOrdersByIdentifierResponse
     */
    public function GetPurchaseOrdersByIdentifier(GetPurchaseOrdersByIdentifier $parameters)
    {
      return $this->__soapCall('GetPurchaseOrdersByIdentifier', array($parameters));
    }

    /**
     * @param GetPurchaseOrdersByDate $parameters
     * @return GetPurchaseOrdersByDateResponse
     */
    public function GetPurchaseOrdersByDate(GetPurchaseOrdersByDate $parameters)
    {
      return $this->__soapCall('GetPurchaseOrdersByDate', array($parameters));
    }

    /**
     * @param GetPurchaseOrdersByWarehouse $parameters
     * @return GetPurchaseOrdersByWarehouseResponse
     */
    public function GetPurchaseOrdersByWarehouse(GetPurchaseOrdersByWarehouse $parameters)
    {
      return $this->__soapCall('GetPurchaseOrdersByWarehouse', array($parameters));
    }

    /**
     * @param GetPurchaseOrdersByWarehouseAndDate $parameters
     * @return GetPurchaseOrdersByWarehouseAndDateResponse
     */
    public function GetPurchaseOrdersByWarehouseAndDate(GetPurchaseOrdersByWarehouseAndDate $parameters)
    {
      return $this->__soapCall('GetPurchaseOrdersByWarehouseAndDate', array($parameters));
    }

    /**
     * @param ConfirmPurchaseOrder $parameters
     * @return ConfirmPurchaseOrderResponse
     */
    public function ConfirmPurchaseOrder(ConfirmPurchaseOrder $parameters)
    {
      return $this->__soapCall('ConfirmPurchaseOrder', array($parameters));
    }

    /**
     * @param ConfirmPurchaseOrders $parameters
     * @return ConfirmPurchaseOrdersResponse
     */
    public function ConfirmPurchaseOrders(ConfirmPurchaseOrders $parameters)
    {
      return $this->__soapCall('ConfirmPurchaseOrders', array($parameters));
    }

    /**
     * @param CancelPurchaseOrder $parameters
     * @return CancelPurchaseOrderResponse
     */
    public function CancelPurchaseOrder(CancelPurchaseOrder $parameters)
    {
      return $this->__soapCall('CancelPurchaseOrder', array($parameters));
    }

    /**
     * @param SubmitPurchaseOrders $parameters
     * @return SubmitPurchaseOrdersResponse
     */
    public function SubmitPurchaseOrders(SubmitPurchaseOrders $parameters)
    {
      return $this->__soapCall('SubmitPurchaseOrders', array($parameters));
    }

    /**
     * @param GetWriteOnOffsByBranchDate $parameters
     * @return GetWriteOnOffsByBranchDateResponse
     */
    public function GetWriteOnOffsByBranchDate(GetWriteOnOffsByBranchDate $parameters)
    {
      return $this->__soapCall('GetWriteOnOffsByBranchDate', array($parameters));
    }

    /**
     * @param GetWriteOnOffsByDate $parameters
     * @return GetWriteOnOffsByDateResponse
     */
    public function GetWriteOnOffsByDate(GetWriteOnOffsByDate $parameters)
    {
      return $this->__soapCall('GetWriteOnOffsByDate', array($parameters));
    }

    /**
     * @param GetWriteOnOffByIdentifier $parameters
     * @return GetWriteOnOffByIdentifierResponse
     */
    public function GetWriteOnOffByIdentifier(GetWriteOnOffByIdentifier $parameters)
    {
      return $this->__soapCall('GetWriteOnOffByIdentifier', array($parameters));
    }

    /**
     * @param SubmitWriteOnOffs $parameters
     * @return SubmitWriteOnOffsResponse
     */
    public function SubmitWriteOnOffs(SubmitWriteOnOffs $parameters)
    {
      return $this->__soapCall('SubmitWriteOnOffs', array($parameters));
    }

    /**
     * @param SubmitReplenishmentTargets $parameters
     * @return SubmitReplenishmentTargetsResponse
     */
    public function SubmitReplenishmentTargets(SubmitReplenishmentTargets $parameters)
    {
      return $this->__soapCall('SubmitReplenishmentTargets', array($parameters));
    }

    /**
     * @param SubmitSkuReplenishmentCeilings $parameters
     * @return SubmitSkuReplenishmentCeilingsResponse
     */
    public function SubmitSkuReplenishmentCeilings(SubmitSkuReplenishmentCeilings $parameters)
    {
      return $this->__soapCall('SubmitSkuReplenishmentCeilings', array($parameters));
    }

    /**
     * @param FlagDataProcessingToRetryByReference $parameters
     * @return FlagDataProcessingToRetryByReferenceResponse
     */
    public function FlagDataProcessingToRetryByReference(FlagDataProcessingToRetryByReference $parameters)
    {
      return $this->__soapCall('FlagDataProcessingToRetryByReference', array($parameters));
    }

    /**
     * @param FlagDataProcessingToRetryByToken $parameters
     * @return FlagDataProcessingToRetryByTokenResponse
     */
    public function FlagDataProcessingToRetryByToken(FlagDataProcessingToRetryByToken $parameters)
    {
      return $this->__soapCall('FlagDataProcessingToRetryByToken', array($parameters));
    }

    /**
     * @param RunDataProcessingByReference $parameters
     * @return RunDataProcessingByReferenceResponse
     */
    public function RunDataProcessingByReference(RunDataProcessingByReference $parameters)
    {
      return $this->__soapCall('RunDataProcessingByReference', array($parameters));
    }

    /**
     * @param RunDataProcessingByToken $parameters
     * @return RunDataProcessingByTokenResponse
     */
    public function RunDataProcessingByToken(RunDataProcessingByToken $parameters)
    {
      return $this->__soapCall('RunDataProcessingByToken', array($parameters));
    }

}
