<?php

namespace Eurostop\Stocks;

class StockForSkuCustom extends RetrievedDataItemOfStockPositionForSkuDto6qbTdoQxCustom
{

    /**
     * @var \DateTime $PositionDate
     */
    protected $PositionDate = null;

    /**
     * @var string $ProductIdentifier
     */
    protected $ProductIdentifier = null;

    /**
     * @var string $SkuIdentifier
     */
    protected $SkuIdentifier = null;

    /**
     * @var int $UnitsFree
     */
    protected $UnitsFree = null;

    /**
     * @var int $UnitsInTransit
     */
    protected $UnitsInTransit = null;

    /**
     * @var int $UnitsLessDemand
     */
    protected $UnitsLessDemand = null;

    /**
     * @param \DateTime $PositionDate
     * @param int $UnitsFree
     * @param int $UnitsInTransit
     * @param int $UnitsLessDemand
     */
    public function __construct(\DateTime $PositionDate, $UnitsFree, $UnitsInTransit, $UnitsLessDemand)
    {
      parent::__construct();
      $this->PositionDate = $PositionDate->format(\DateTime::ATOM);
      $this->UnitsFree = $UnitsFree;
      $this->UnitsInTransit = $UnitsInTransit;
      $this->UnitsLessDemand = $UnitsLessDemand;
    }

    /**
     * @return \DateTime
     */
    public function getPositionDate()
    {
      if ($this->PositionDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->PositionDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $PositionDate
     * @return \Eurostop\Stocks\StockForSku
     */
    public function setPositionDate(\DateTime $PositionDate)
    {
      $this->PositionDate = $PositionDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return string
     */
    public function getProductIdentifier()
    {
      return $this->ProductIdentifier;
    }

    /**
     * @param string $ProductIdentifier
     * @return \Eurostop\Stocks\StockForSku
     */
    public function setProductIdentifier($ProductIdentifier)
    {
      $this->ProductIdentifier = $ProductIdentifier;
      return $this;
    }

    /**
     * @return string
     */
    public function getSkuIdentifier()
    {
      return $this->SkuIdentifier;
    }

    /**
     * @param string $SkuIdentifier
     * @return \Eurostop\Stocks\StockForSku
     */
    public function setSkuIdentifier($SkuIdentifier)
    {
      $this->SkuIdentifier = $SkuIdentifier;
      return $this;
    }

    /**
     * @return int
     */
    public function getUnitsFree()
    {
      return $this->UnitsFree;
    }

    /**
     * @param int $UnitsFree
     * @return \Eurostop\Stocks\StockForSku
     */
    public function setUnitsFree($UnitsFree)
    {
      $this->UnitsFree = $UnitsFree;
      return $this;
    }

    /**
     * @return int
     */
    public function getUnitsInTransit()
    {
      return $this->UnitsInTransit;
    }

    /**
     * @param int $UnitsInTransit
     * @return \Eurostop\Stocks\StockForSku
     */
    public function setUnitsInTransit($UnitsInTransit)
    {
      $this->UnitsInTransit = $UnitsInTransit;
      return $this;
    }

    /**
     * @return int
     */
    public function getUnitsLessDemand()
    {
      return $this->UnitsLessDemand;
    }

    /**
     * @param int $UnitsLessDemand
     * @return \Eurostop\Stocks\StockForSku
     */
    public function setUnitsLessDemand($UnitsLessDemand)
    {
      $this->UnitsLessDemand = $UnitsLessDemand;
      return $this;
    }

}
