<?php

namespace Eurostop\Stocks;

class PurchaseOrderHeader extends CodedRetrievedDataItemOfPurchaseOrderHeaderDto6qbTdoQx
{

    /**
     * @var \DateTime $AuthorisedDate
     */
    protected $AuthorisedDate = null;

    /**
     * @var string $BranchIdentifier
     */
    protected $BranchIdentifier = null;

    /**
     * @var string $Comments
     */
    protected $Comments = null;

    /**
     * @var \DateTime $CreatedDate
     */
    protected $CreatedDate = null;

    /**
     * @var string $CurrencyIdentifier
     */
    protected $CurrencyIdentifier = null;

    /**
     * @var \DateTime $CustomDate1
     */
    protected $CustomDate1 = null;

    /**
     * @var \DateTime $CustomDate2
     */
    protected $CustomDate2 = null;

    /**
     * @var \DateTime $CustomDate3
     */
    protected $CustomDate3 = null;

    /**
     * @var \DateTime $DeliveryEndDate
     */
    protected $DeliveryEndDate = null;

    /**
     * @var \DateTime $DeliveryStartDate
     */
    protected $DeliveryStartDate = null;

    /**
     * @var boolean $IsCancelled
     */
    protected $IsCancelled = null;

    /**
     * @var ArrayOfPurchaseOrderDetail $Lines
     */
    protected $Lines = null;

    /**
     * @var int $PurchaseOrderId
     */
    protected $PurchaseOrderId = null;

    /**
     * @var string $Reference
     */
    protected $Reference = null;

    /**
     * @var string $SupplierIdentifier
     */
    protected $SupplierIdentifier = null;

    
    public function __construct()
    {
      parent::__construct();
    }

    /**
     * @return \DateTime
     */
    public function getAuthorisedDate()
    {
      if ($this->AuthorisedDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->AuthorisedDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $AuthorisedDate
     * @return \Eurostop\Stocks\PurchaseOrderHeader
     */
    public function setAuthorisedDate(\DateTime $AuthorisedDate = null)
    {
      if ($AuthorisedDate == null) {
       $this->AuthorisedDate = null;
      } else {
        $this->AuthorisedDate = $AuthorisedDate->format(\DateTime::ATOM);
      }
      return $this;
    }

    /**
     * @return string
     */
    public function getBranchIdentifier()
    {
      return $this->BranchIdentifier;
    }

    /**
     * @param string $BranchIdentifier
     * @return \Eurostop\Stocks\PurchaseOrderHeader
     */
    public function setBranchIdentifier($BranchIdentifier)
    {
      $this->BranchIdentifier = $BranchIdentifier;
      return $this;
    }

    /**
     * @return string
     */
    public function getComments()
    {
      return $this->Comments;
    }

    /**
     * @param string $Comments
     * @return \Eurostop\Stocks\PurchaseOrderHeader
     */
    public function setComments($Comments)
    {
      $this->Comments = $Comments;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getCreatedDate()
    {
      if ($this->CreatedDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->CreatedDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $CreatedDate
     * @return \Eurostop\Stocks\PurchaseOrderHeader
     */
    public function setCreatedDate(\DateTime $CreatedDate = null)
    {
      if ($CreatedDate == null) {
       $this->CreatedDate = null;
      } else {
        $this->CreatedDate = $CreatedDate->format(\DateTime::ATOM);
      }
      return $this;
    }

    /**
     * @return string
     */
    public function getCurrencyIdentifier()
    {
      return $this->CurrencyIdentifier;
    }

    /**
     * @param string $CurrencyIdentifier
     * @return \Eurostop\Stocks\PurchaseOrderHeader
     */
    public function setCurrencyIdentifier($CurrencyIdentifier)
    {
      $this->CurrencyIdentifier = $CurrencyIdentifier;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getCustomDate1()
    {
      if ($this->CustomDate1 == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->CustomDate1);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $CustomDate1
     * @return \Eurostop\Stocks\PurchaseOrderHeader
     */
    public function setCustomDate1(\DateTime $CustomDate1 = null)
    {
      if ($CustomDate1 == null) {
       $this->CustomDate1 = null;
      } else {
        $this->CustomDate1 = $CustomDate1->format(\DateTime::ATOM);
      }
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getCustomDate2()
    {
      if ($this->CustomDate2 == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->CustomDate2);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $CustomDate2
     * @return \Eurostop\Stocks\PurchaseOrderHeader
     */
    public function setCustomDate2(\DateTime $CustomDate2 = null)
    {
      if ($CustomDate2 == null) {
       $this->CustomDate2 = null;
      } else {
        $this->CustomDate2 = $CustomDate2->format(\DateTime::ATOM);
      }
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getCustomDate3()
    {
      if ($this->CustomDate3 == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->CustomDate3);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $CustomDate3
     * @return \Eurostop\Stocks\PurchaseOrderHeader
     */
    public function setCustomDate3(\DateTime $CustomDate3 = null)
    {
      if ($CustomDate3 == null) {
       $this->CustomDate3 = null;
      } else {
        $this->CustomDate3 = $CustomDate3->format(\DateTime::ATOM);
      }
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getDeliveryEndDate()
    {
      if ($this->DeliveryEndDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->DeliveryEndDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $DeliveryEndDate
     * @return \Eurostop\Stocks\PurchaseOrderHeader
     */
    public function setDeliveryEndDate(\DateTime $DeliveryEndDate = null)
    {
      if ($DeliveryEndDate == null) {
       $this->DeliveryEndDate = null;
      } else {
        $this->DeliveryEndDate = $DeliveryEndDate->format(\DateTime::ATOM);
      }
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getDeliveryStartDate()
    {
      if ($this->DeliveryStartDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->DeliveryStartDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $DeliveryStartDate
     * @return \Eurostop\Stocks\PurchaseOrderHeader
     */
    public function setDeliveryStartDate(\DateTime $DeliveryStartDate = null)
    {
      if ($DeliveryStartDate == null) {
       $this->DeliveryStartDate = null;
      } else {
        $this->DeliveryStartDate = $DeliveryStartDate->format(\DateTime::ATOM);
      }
      return $this;
    }

    /**
     * @return boolean
     */
    public function getIsCancelled()
    {
      return $this->IsCancelled;
    }

    /**
     * @param boolean $IsCancelled
     * @return \Eurostop\Stocks\PurchaseOrderHeader
     */
    public function setIsCancelled($IsCancelled)
    {
      $this->IsCancelled = $IsCancelled;
      return $this;
    }

    /**
     * @return ArrayOfPurchaseOrderDetail
     */
    public function getLines()
    {
      return $this->Lines;
    }

    /**
     * @param ArrayOfPurchaseOrderDetail $Lines
     * @return \Eurostop\Stocks\PurchaseOrderHeader
     */
    public function setLines($Lines)
    {
      $this->Lines = $Lines;
      return $this;
    }

    /**
     * @return int
     */
    public function getPurchaseOrderId()
    {
      return $this->PurchaseOrderId;
    }

    /**
     * @param int $PurchaseOrderId
     * @return \Eurostop\Stocks\PurchaseOrderHeader
     */
    public function setPurchaseOrderId($PurchaseOrderId)
    {
      $this->PurchaseOrderId = $PurchaseOrderId;
      return $this;
    }

    /**
     * @return string
     */
    public function getReference()
    {
      return $this->Reference;
    }

    /**
     * @param string $Reference
     * @return \Eurostop\Stocks\PurchaseOrderHeader
     */
    public function setReference($Reference)
    {
      $this->Reference = $Reference;
      return $this;
    }

    /**
     * @return string
     */
    public function getSupplierIdentifier()
    {
      return $this->SupplierIdentifier;
    }

    /**
     * @param string $SupplierIdentifier
     * @return \Eurostop\Stocks\PurchaseOrderHeader
     */
    public function setSupplierIdentifier($SupplierIdentifier)
    {
      $this->SupplierIdentifier = $SupplierIdentifier;
      return $this;
    }

}
