<?php

namespace Eurostop\Stocks;

class GetPurchaseOrdersByWarehouseAndConfirmedDate
{

    /**
     * @var string $warehouseIdentifier
     */
    protected $warehouseIdentifier = null;

    /**
     * @var BranchIdentifierType $branchIdentifierType
     */
    protected $branchIdentifierType = null;

    /**
     * @var \DateTime $confirmedFromDate
     */
    protected $confirmedFromDate = null;

    /**
     * @var \DateTime $confirmedToDate
     */
    protected $confirmedToDate = null;

    /**
     * @param string $warehouseIdentifier
     * @param BranchIdentifierType $branchIdentifierType
     * @param \DateTime $confirmedFromDate
     * @param \DateTime $confirmedToDate
     */
    public function __construct($warehouseIdentifier, $branchIdentifierType, \DateTime $confirmedFromDate, \DateTime $confirmedToDate)
    {
      $this->warehouseIdentifier = $warehouseIdentifier;
      $this->branchIdentifierType = $branchIdentifierType;
      $this->confirmedFromDate = $confirmedFromDate->format(\DateTime::ATOM);
      $this->confirmedToDate = $confirmedToDate->format(\DateTime::ATOM);
    }

    /**
     * @return string
     */
    public function getWarehouseIdentifier()
    {
      return $this->warehouseIdentifier;
    }

    /**
     * @param string $warehouseIdentifier
     * @return \Eurostop\Stocks\GetPurchaseOrdersByWarehouseAndConfirmedDate
     */
    public function setWarehouseIdentifier($warehouseIdentifier)
    {
      $this->warehouseIdentifier = $warehouseIdentifier;
      return $this;
    }

    /**
     * @return BranchIdentifierType
     */
    public function getBranchIdentifierType()
    {
      return $this->branchIdentifierType;
    }

    /**
     * @param BranchIdentifierType $branchIdentifierType
     * @return \Eurostop\Stocks\GetPurchaseOrdersByWarehouseAndConfirmedDate
     */
    public function setBranchIdentifierType($branchIdentifierType)
    {
      $this->branchIdentifierType = $branchIdentifierType;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getConfirmedFromDate()
    {
      if ($this->confirmedFromDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->confirmedFromDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $confirmedFromDate
     * @return \Eurostop\Stocks\GetPurchaseOrdersByWarehouseAndConfirmedDate
     */
    public function setConfirmedFromDate(\DateTime $confirmedFromDate)
    {
      $this->confirmedFromDate = $confirmedFromDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getConfirmedToDate()
    {
      if ($this->confirmedToDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->confirmedToDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $confirmedToDate
     * @return \Eurostop\Stocks\GetPurchaseOrdersByWarehouseAndConfirmedDate
     */
    public function setConfirmedToDate(\DateTime $confirmedToDate)
    {
      $this->confirmedToDate = $confirmedToDate->format(\DateTime::ATOM);
      return $this;
    }

}
