<?php

namespace Eurostop\Stocks;

class GetPurchaseOrdersByIdentifier
{

    /**
     * @var string $purchaseOrderIdentifier
     */
    protected $purchaseOrderIdentifier = null;

    /**
     * @var PurchaseOrderIdentifierType $purchaseOrderIdentifierType
     */
    protected $purchaseOrderIdentifierType = null;

    /**
     * @param string $purchaseOrderIdentifier
     * @param PurchaseOrderIdentifierType $purchaseOrderIdentifierType
     */
    public function __construct($purchaseOrderIdentifier = null, $purchaseOrderIdentifierType = null)
    {
      $this->purchaseOrderIdentifier = $purchaseOrderIdentifier;
      $this->purchaseOrderIdentifierType = $purchaseOrderIdentifierType;
    }

    /**
     * @return string
     */
    public function getPurchaseOrderIdentifier()
    {
      return $this->purchaseOrderIdentifier;
    }

    /**
     * @param string $purchaseOrderIdentifier
     * @return \Eurostop\Stocks\GetPurchaseOrdersByIdentifier
     */
    public function setPurchaseOrderIdentifier($purchaseOrderIdentifier)
    {
      $this->purchaseOrderIdentifier = $purchaseOrderIdentifier;
      return $this;
    }

    /**
     * @return PurchaseOrderIdentifierType
     */
    public function getPurchaseOrderIdentifierType()
    {
      return $this->purchaseOrderIdentifierType;
    }

    /**
     * @param PurchaseOrderIdentifierType $purchaseOrderIdentifierType
     * @return \Eurostop\Stocks\GetPurchaseOrdersByIdentifier
     */
    public function setPurchaseOrderIdentifierType($purchaseOrderIdentifierType)
    {
      $this->purchaseOrderIdentifierType = $purchaseOrderIdentifierType;
      return $this;
    }

}
