<?php

namespace Eurostop\Stocks;

class GetInOutTransfersByBranchBookedInDate
{

    /**
     * @var string $fromBranchIdentifier
     */
    protected $fromBranchIdentifier = null;

    /**
     * @var string $toBranchIdentifier
     */
    protected $toBranchIdentifier = null;

    /**
     * @var BranchIdentifierType $branchIdentifierType
     */
    protected $branchIdentifierType = null;

    /**
     * @var \DateTime $bookedInFromDate
     */
    protected $bookedInFromDate = null;

    /**
     * @var \DateTime $bookedInToDate
     */
    protected $bookedInToDate = null;

    /**
     * @var boolean $includeTransfersOut
     */
    protected $includeTransfersOut = null;

    /**
     * @var boolean $includeTransfersIn
     */
    protected $includeTransfersIn = null;

    /**
     * @param string $fromBranchIdentifier
     * @param string $toBranchIdentifier
     * @param BranchIdentifierType $branchIdentifierType
     * @param \DateTime $bookedInFromDate
     * @param \DateTime $bookedInToDate
     * @param boolean $includeTransfersOut
     * @param boolean $includeTransfersIn
     */
    public function __construct($fromBranchIdentifier, $toBranchIdentifier, $branchIdentifierType, \DateTime $bookedInFromDate, \DateTime $bookedInToDate, $includeTransfersOut, $includeTransfersIn)
    {
      $this->fromBranchIdentifier = $fromBranchIdentifier;
      $this->toBranchIdentifier = $toBranchIdentifier;
      $this->branchIdentifierType = $branchIdentifierType;
      $this->bookedInFromDate = $bookedInFromDate->format(\DateTime::ATOM);
      $this->bookedInToDate = $bookedInToDate->format(\DateTime::ATOM);
      $this->includeTransfersOut = $includeTransfersOut;
      $this->includeTransfersIn = $includeTransfersIn;
    }

    /**
     * @return string
     */
    public function getFromBranchIdentifier()
    {
      return $this->fromBranchIdentifier;
    }

    /**
     * @param string $fromBranchIdentifier
     * @return \Eurostop\Stocks\GetInOutTransfersByBranchBookedInDate
     */
    public function setFromBranchIdentifier($fromBranchIdentifier)
    {
      $this->fromBranchIdentifier = $fromBranchIdentifier;
      return $this;
    }

    /**
     * @return string
     */
    public function getToBranchIdentifier()
    {
      return $this->toBranchIdentifier;
    }

    /**
     * @param string $toBranchIdentifier
     * @return \Eurostop\Stocks\GetInOutTransfersByBranchBookedInDate
     */
    public function setToBranchIdentifier($toBranchIdentifier)
    {
      $this->toBranchIdentifier = $toBranchIdentifier;
      return $this;
    }

    /**
     * @return BranchIdentifierType
     */
    public function getBranchIdentifierType()
    {
      return $this->branchIdentifierType;
    }

    /**
     * @param BranchIdentifierType $branchIdentifierType
     * @return \Eurostop\Stocks\GetInOutTransfersByBranchBookedInDate
     */
    public function setBranchIdentifierType($branchIdentifierType)
    {
      $this->branchIdentifierType = $branchIdentifierType;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getBookedInFromDate()
    {
      if ($this->bookedInFromDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->bookedInFromDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $bookedInFromDate
     * @return \Eurostop\Stocks\GetInOutTransfersByBranchBookedInDate
     */
    public function setBookedInFromDate(\DateTime $bookedInFromDate)
    {
      $this->bookedInFromDate = $bookedInFromDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getBookedInToDate()
    {
      if ($this->bookedInToDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->bookedInToDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $bookedInToDate
     * @return \Eurostop\Stocks\GetInOutTransfersByBranchBookedInDate
     */
    public function setBookedInToDate(\DateTime $bookedInToDate)
    {
      $this->bookedInToDate = $bookedInToDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return boolean
     */
    public function getIncludeTransfersOut()
    {
      return $this->includeTransfersOut;
    }

    /**
     * @param boolean $includeTransfersOut
     * @return \Eurostop\Stocks\GetInOutTransfersByBranchBookedInDate
     */
    public function setIncludeTransfersOut($includeTransfersOut)
    {
      $this->includeTransfersOut = $includeTransfersOut;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getIncludeTransfersIn()
    {
      return $this->includeTransfersIn;
    }

    /**
     * @param boolean $includeTransfersIn
     * @return \Eurostop\Stocks\GetInOutTransfersByBranchBookedInDate
     */
    public function setIncludeTransfersIn($includeTransfersIn)
    {
      $this->includeTransfersIn = $includeTransfersIn;
      return $this;
    }

}
