<?php

namespace Eurostop\Stocks;

class GetDeliveriesByDates
{

    /**
     * @var \DateTime $startDate
     */
    protected $startDate = null;

    /**
     * @var \DateTime $endDate
     */
    protected $endDate = null;

    /**
     * @var boolean $includeUnConfirmed
     */
    protected $includeUnConfirmed = null;

    /**
     * @param \DateTime $startDate
     * @param \DateTime $endDate
     * @param boolean $includeUnConfirmed
     */
    public function __construct(\DateTime $startDate = null, \DateTime $endDate = null, $includeUnConfirmed = null)
    {
      $this->startDate = $startDate ? $startDate->format(\DateTime::ATOM) : null;
      $this->endDate = $endDate ? $endDate->format(\DateTime::ATOM) : null;
      $this->includeUnConfirmed = $includeUnConfirmed;
    }

    /**
     * @return \DateTime
     */
    public function getStartDate()
    {
      if ($this->startDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->startDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $startDate
     * @return \Eurostop\Stocks\GetDeliveriesByDates
     */
    public function setStartDate(\DateTime $startDate)
    {
      $this->startDate = $startDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getEndDate()
    {
      if ($this->endDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->endDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $endDate
     * @return \Eurostop\Stocks\GetDeliveriesByDates
     */
    public function setEndDate(\DateTime $endDate)
    {
      $this->endDate = $endDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return boolean
     */
    public function getIncludeUnConfirmed()
    {
      return $this->includeUnConfirmed;
    }

    /**
     * @param boolean $includeUnConfirmed
     * @return \Eurostop\Stocks\GetDeliveriesByDates
     */
    public function setIncludeUnConfirmed($includeUnConfirmed)
    {
      $this->includeUnConfirmed = $includeUnConfirmed;
      return $this;
    }

}
