<?php

namespace Eurostop\Stocks;

class GetCurrentStockPositionByBranchListAndProductList
{

    /**
     * @var ArrayOfstring $branchIdentifiers
     */
    protected $branchIdentifiers = null;

    /**
     * @var BranchIdentifierType $branchIdentifierType
     */
    protected $branchIdentifierType = null;

    /**
     * @var ArrayOfstring $productIdentifiers
     */
    protected $productIdentifiers = null;

    /**
     * @var ProductIdentifierType $productIdentifierType
     */
    protected $productIdentifierType = null;

    /**
     * @var \DateTime $modifiedSinceDate
     */
    protected $modifiedSinceDate = null;

    /**
     * @var boolean $nonZeroOnly
     */
    protected $nonZeroOnly = null;

    /**
     * @param ArrayOfstring $branchIdentifiers
     * @param BranchIdentifierType $branchIdentifierType
     * @param ArrayOfstring $productIdentifiers
     * @param ProductIdentifierType $productIdentifierType
     * @param \DateTime $modifiedSinceDate
     * @param boolean $nonZeroOnly
     */
    public function __construct($branchIdentifiers, $branchIdentifierType, $productIdentifiers, $productIdentifierType, \DateTime $modifiedSinceDate, $nonZeroOnly)
    {
      $this->branchIdentifiers = $branchIdentifiers;
      $this->branchIdentifierType = $branchIdentifierType;
      $this->productIdentifiers = $productIdentifiers;
      $this->productIdentifierType = $productIdentifierType;
      $this->modifiedSinceDate = $modifiedSinceDate->format(\DateTime::ATOM);
      $this->nonZeroOnly = $nonZeroOnly;
    }

    /**
     * @return ArrayOfstring
     */
    public function getBranchIdentifiers()
    {
      return $this->branchIdentifiers;
    }

    /**
     * @param ArrayOfstring $branchIdentifiers
     * @return \Eurostop\Stocks\GetCurrentStockPositionByBranchListAndProductList
     */
    public function setBranchIdentifiers($branchIdentifiers)
    {
      $this->branchIdentifiers = $branchIdentifiers;
      return $this;
    }

    /**
     * @return BranchIdentifierType
     */
    public function getBranchIdentifierType()
    {
      return $this->branchIdentifierType;
    }

    /**
     * @param BranchIdentifierType $branchIdentifierType
     * @return \Eurostop\Stocks\GetCurrentStockPositionByBranchListAndProductList
     */
    public function setBranchIdentifierType($branchIdentifierType)
    {
      $this->branchIdentifierType = $branchIdentifierType;
      return $this;
    }

    /**
     * @return ArrayOfstring
     */
    public function getProductIdentifiers()
    {
      return $this->productIdentifiers;
    }

    /**
     * @param ArrayOfstring $productIdentifiers
     * @return \Eurostop\Stocks\GetCurrentStockPositionByBranchListAndProductList
     */
    public function setProductIdentifiers($productIdentifiers)
    {
      $this->productIdentifiers = $productIdentifiers;
      return $this;
    }

    /**
     * @return ProductIdentifierType
     */
    public function getProductIdentifierType()
    {
      return $this->productIdentifierType;
    }

    /**
     * @param ProductIdentifierType $productIdentifierType
     * @return \Eurostop\Stocks\GetCurrentStockPositionByBranchListAndProductList
     */
    public function setProductIdentifierType($productIdentifierType)
    {
      $this->productIdentifierType = $productIdentifierType;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getModifiedSinceDate()
    {
      if ($this->modifiedSinceDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->modifiedSinceDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $modifiedSinceDate
     * @return \Eurostop\Stocks\GetCurrentStockPositionByBranchListAndProductList
     */
    public function setModifiedSinceDate(\DateTime $modifiedSinceDate)
    {
      $this->modifiedSinceDate = $modifiedSinceDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return boolean
     */
    public function getNonZeroOnly()
    {
      return $this->nonZeroOnly;
    }

    /**
     * @param boolean $nonZeroOnly
     * @return \Eurostop\Stocks\GetCurrentStockPositionByBranchListAndProductList
     */
    public function setNonZeroOnly($nonZeroOnly)
    {
      $this->nonZeroOnly = $nonZeroOnly;
      return $this;
    }

}
