<?php

namespace Eurostop\Stocks;

class GetCurrentSkuStockByBranchGroupAndSkuListCustom
{

    /**
     * @var string $branchGroupIdentifier
     */
    protected $branchGroupIdentifier = null;

    /**
     * @var BranchGroupIdentifierType $branchGroupIdentifierType
     */
    protected $branchGroupIdentifierType = null;

    /**
     * @var ArrayOfstring $skuIdentifiers
     */
    protected $skuIdentifiers = null;

    /**
     * @var SkuIdentifierType $skuIdentifierType
     */
    protected $skuIdentifierType = null;

    /**
     * @var \DateTime $modifiedSinceDate
     */
    protected $modifiedSinceDate = null;

    /**
     * @var boolean $nonZeroOnly
     */
    protected $nonZeroOnly = null;

    /**
     * @param string $branchGroupIdentifier
     * @param BranchGroupIdentifierType $branchGroupIdentifierType
     * @param ArrayOfstring $skuIdentifiers
     * @param SkuIdentifierType $skuIdentifierType
     * @param \DateTime $modifiedSinceDate
     * @param boolean $nonZeroOnly
     */
    public function __construct($branchGroupIdentifier, $branchGroupIdentifierType, $skuIdentifiers, $skuIdentifierType, \DateTime $modifiedSinceDate, $nonZeroOnly)
    {
      $this->branchGroupIdentifier = $branchGroupIdentifier;
      $this->branchGroupIdentifierType = $branchGroupIdentifierType;
      $this->skuIdentifiers = $skuIdentifiers;
      $this->skuIdentifierType = $skuIdentifierType;
      $this->modifiedSinceDate = $modifiedSinceDate->format(\DateTime::ATOM);
      $this->nonZeroOnly = $nonZeroOnly;
    }

    /**
     * @return string
     */
    public function getBranchGroupIdentifier()
    {
      return $this->branchGroupIdentifier;
    }

    /**
     * @param string $branchGroupIdentifier
     * @return \Eurostop\Stocks\GetCurrentSkuStockByBranchGroupAndSkuList
     */
    public function setBranchGroupIdentifier($branchGroupIdentifier)
    {
      $this->branchGroupIdentifier = $branchGroupIdentifier;
      return $this;
    }

    /**
     * @return BranchGroupIdentifierType
     */
    public function getBranchGroupIdentifierType()
    {
      return $this->branchGroupIdentifierType;
    }

    /**
     * @param BranchGroupIdentifierType $branchGroupIdentifierType
     * @return \Eurostop\Stocks\GetCurrentSkuStockByBranchGroupAndSkuList
     */
    public function setBranchGroupIdentifierType($branchGroupIdentifierType)
    {
      $this->branchGroupIdentifierType = $branchGroupIdentifierType;
      return $this;
    }

    /**
     * @return ArrayOfstring
     */
    public function getSkuIdentifiers()
    {
      return $this->skuIdentifiers;
    }

    /**
     * @param ArrayOfstring $skuIdentifiers
     * @return \Eurostop\Stocks\GetCurrentSkuStockByBranchGroupAndSkuList
     */
    public function setSkuIdentifiers($skuIdentifiers)
    {
      $this->skuIdentifiers = $skuIdentifiers;
      return $this;
    }

    /**
     * @return SkuIdentifierType
     */
    public function getSkuIdentifierType()
    {
      return $this->skuIdentifierType;
    }

    /**
     * @param SkuIdentifierType $skuIdentifierType
     * @return \Eurostop\Stocks\GetCurrentSkuStockByBranchGroupAndSkuList
     */
    public function setSkuIdentifierType($skuIdentifierType)
    {
      $this->skuIdentifierType = $skuIdentifierType;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getModifiedSinceDate()
    {
      if ($this->modifiedSinceDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->modifiedSinceDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $modifiedSinceDate
     * @return \Eurostop\Stocks\GetCurrentSkuStockByBranchGroupAndSkuList
     */
    public function setModifiedSinceDate(\DateTime $modifiedSinceDate)
    {
      $this->modifiedSinceDate = $modifiedSinceDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return boolean
     */
    public function getNonZeroOnly()
    {
      return $this->nonZeroOnly;
    }

    /**
     * @param boolean $nonZeroOnly
     * @return \Eurostop\Stocks\GetCurrentSkuStockByBranchGroupAndSkuList
     */
    public function setNonZeroOnly($nonZeroOnly)
    {
      $this->nonZeroOnly = $nonZeroOnly;
      return $this;
    }

}
