<?php

namespace Eurostop\Stocks;

class GetConsolidatedTransfersByBookedInDate
{

    /**
     * @var \DateTime $bookedInFromDate
     */
    protected $bookedInFromDate = null;

    /**
     * @var \DateTime $bookedInToDate
     */
    protected $bookedInToDate = null;

    /**
     * @param \DateTime $bookedInFromDate
     * @param \DateTime $bookedInToDate
     */
    public function __construct(\DateTime $bookedInFromDate, \DateTime $bookedInToDate)
    {
      $this->bookedInFromDate = $bookedInFromDate->format(\DateTime::ATOM);
      $this->bookedInToDate = $bookedInToDate->format(\DateTime::ATOM);
    }

    /**
     * @return \DateTime
     */
    public function getBookedInFromDate()
    {
      if ($this->bookedInFromDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->bookedInFromDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $bookedInFromDate
     * @return \Eurostop\Stocks\GetConsolidatedTransfersByBookedInDate
     */
    public function setBookedInFromDate(\DateTime $bookedInFromDate)
    {
      $this->bookedInFromDate = $bookedInFromDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getBookedInToDate()
    {
      if ($this->bookedInToDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->bookedInToDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $bookedInToDate
     * @return \Eurostop\Stocks\GetConsolidatedTransfersByBookedInDate
     */
    public function setBookedInToDate(\DateTime $bookedInToDate)
    {
      $this->bookedInToDate = $bookedInToDate->format(\DateTime::ATOM);
      return $this;
    }

}
