<?php

namespace Eurostop\Stocks;

class ConfirmTransfer
{

    /**
     * @var string $transferIdentifier
     */
    protected $transferIdentifier = null;

    /**
     * @var TransferIdentifierType $transferIdentifierType
     */
    protected $transferIdentifierType = null;

    /**
     * @var string $submissionReference
     */
    protected $submissionReference = null;

    /**
     * @param string $transferIdentifier
     * @param TransferIdentifierType $transferIdentifierType
     * @param string $submissionReference
     */
    public function __construct($transferIdentifier = null, $transferIdentifierType = null, $submissionReference = null)
    {
      $this->transferIdentifier = $transferIdentifier;
      $this->transferIdentifierType = $transferIdentifierType;
      $this->submissionReference = $submissionReference;
    }

    /**
     * @return string
     */
    public function getTransferIdentifier()
    {
      return $this->transferIdentifier;
    }

    /**
     * @param string $transferIdentifier
     * @return \Eurostop\Stocks\ConfirmTransfer
     */
    public function setTransferIdentifier($transferIdentifier)
    {
      $this->transferIdentifier = $transferIdentifier;
      return $this;
    }

    /**
     * @return TransferIdentifierType
     */
    public function getTransferIdentifierType()
    {
      return $this->transferIdentifierType;
    }

    /**
     * @param TransferIdentifierType $transferIdentifierType
     * @return \Eurostop\Stocks\ConfirmTransfer
     */
    public function setTransferIdentifierType($transferIdentifierType)
    {
      $this->transferIdentifierType = $transferIdentifierType;
      return $this;
    }

    /**
     * @return string
     */
    public function getSubmissionReference()
    {
      return $this->submissionReference;
    }

    /**
     * @param string $submissionReference
     * @return \Eurostop\Stocks\ConfirmTransfer
     */
    public function setSubmissionReference($submissionReference)
    {
      $this->submissionReference = $submissionReference;
      return $this;
    }

}
