<?php

namespace Eurostop\Stocks;

class ConfirmPurchaseOrders
{

    /**
     * @var ArrayOfstring $purchaseOrderIdentifiers
     */
    protected $purchaseOrderIdentifiers = null;

    /**
     * @var PurchaseOrderIdentifierType $purchaseOrderIdentifierType
     */
    protected $purchaseOrderIdentifierType = null;

    /**
     * @var string $submissionReference
     */
    protected $submissionReference = null;

    /**
     * @param ArrayOfstring $purchaseOrderIdentifiers
     * @param PurchaseOrderIdentifierType $purchaseOrderIdentifierType
     * @param string $submissionReference
     */
    public function __construct($purchaseOrderIdentifiers = null, $purchaseOrderIdentifierType = null, $submissionReference = null)
    {
      $this->purchaseOrderIdentifiers = $purchaseOrderIdentifiers;
      $this->purchaseOrderIdentifierType = $purchaseOrderIdentifierType;
      $this->submissionReference = $submissionReference;
    }

    /**
     * @return ArrayOfstring
     */
    public function getPurchaseOrderIdentifiers()
    {
      return $this->purchaseOrderIdentifiers;
    }

    /**
     * @param ArrayOfstring $purchaseOrderIdentifiers
     * @return \Eurostop\Stocks\ConfirmPurchaseOrders
     */
    public function setPurchaseOrderIdentifiers($purchaseOrderIdentifiers)
    {
      $this->purchaseOrderIdentifiers = $purchaseOrderIdentifiers;
      return $this;
    }

    /**
     * @return PurchaseOrderIdentifierType
     */
    public function getPurchaseOrderIdentifierType()
    {
      return $this->purchaseOrderIdentifierType;
    }

    /**
     * @param PurchaseOrderIdentifierType $purchaseOrderIdentifierType
     * @return \Eurostop\Stocks\ConfirmPurchaseOrders
     */
    public function setPurchaseOrderIdentifierType($purchaseOrderIdentifierType)
    {
      $this->purchaseOrderIdentifierType = $purchaseOrderIdentifierType;
      return $this;
    }

    /**
     * @return string
     */
    public function getSubmissionReference()
    {
      return $this->submissionReference;
    }

    /**
     * @param string $submissionReference
     * @return \Eurostop\Stocks\ConfirmPurchaseOrders
     */
    public function setSubmissionReference($submissionReference)
    {
      $this->submissionReference = $submissionReference;
      return $this;
    }

}
