<?php

namespace Eurostop\Stocks;

class CancelPurchaseOrder
{

    /**
     * @var string $purchaseOrderIdentifier
     */
    protected $purchaseOrderIdentifier = null;

    /**
     * @var PurchaseOrderIdentifierType $purchaseOrderIdentifierType
     */
    protected $purchaseOrderIdentifierType = null;

    /**
     * @var string $submissionReference
     */
    protected $submissionReference = null;

    /**
     * @param string $purchaseOrderIdentifier
     * @param PurchaseOrderIdentifierType $purchaseOrderIdentifierType
     * @param string $submissionReference
     */
    public function __construct($purchaseOrderIdentifier = null, $purchaseOrderIdentifierType = null, $submissionReference = null)
    {
      $this->purchaseOrderIdentifier = $purchaseOrderIdentifier;
      $this->purchaseOrderIdentifierType = $purchaseOrderIdentifierType;
      $this->submissionReference = $submissionReference;
    }

    /**
     * @return string
     */
    public function getPurchaseOrderIdentifier()
    {
      return $this->purchaseOrderIdentifier;
    }

    /**
     * @param string $purchaseOrderIdentifier
     * @return \Eurostop\Stocks\CancelPurchaseOrder
     */
    public function setPurchaseOrderIdentifier($purchaseOrderIdentifier)
    {
      $this->purchaseOrderIdentifier = $purchaseOrderIdentifier;
      return $this;
    }

    /**
     * @return PurchaseOrderIdentifierType
     */
    public function getPurchaseOrderIdentifierType()
    {
      return $this->purchaseOrderIdentifierType;
    }

    /**
     * @param PurchaseOrderIdentifierType $purchaseOrderIdentifierType
     * @return \Eurostop\Stocks\CancelPurchaseOrder
     */
    public function setPurchaseOrderIdentifierType($purchaseOrderIdentifierType)
    {
      $this->purchaseOrderIdentifierType = $purchaseOrderIdentifierType;
      return $this;
    }

    /**
     * @return string
     */
    public function getSubmissionReference()
    {
      return $this->submissionReference;
    }

    /**
     * @param string $submissionReference
     * @return \Eurostop\Stocks\CancelPurchaseOrder
     */
    public function setSubmissionReference($submissionReference)
    {
      $this->submissionReference = $submissionReference;
      return $this;
    }

}
