<?php

namespace Eurostop\Stocks;

class ArrayOfWriteOnOffHeaderCustom implements \ArrayAccess, \Iterator, \Countable
{

    /**
     * @var WriteOnOffHeader[] $WriteOnOffHeader
     */
    protected $WriteOnOffHeader = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return WriteOnOffHeader[]
     */
    public function getWriteOnOffHeader()
    {
      return $this->WriteOnOffHeader;
    }

    /**
     * @param WriteOnOffHeader[] $WriteOnOffHeader
     * @return \Eurostop\Stocks\ArrayOfWriteOnOffHeader
     */
    public function setWriteOnOffHeader(array $WriteOnOffHeader = null)
    {
      $this->WriteOnOffHeader = $WriteOnOffHeader;
      return $this;
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset An offset to check for
     * @return boolean true on success or false on failure
     */
    public function offsetExists($offset)
    {
      return isset($this->WriteOnOffHeader[$offset]);
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to retrieve
     * @return WriteOnOffHeader
     */
    public function offsetGet($offset)
    {
      return $this->WriteOnOffHeader[$offset];
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to assign the value to
     * @param WriteOnOffHeader $value The value to set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
      if (!isset($offset)) {
        $this->WriteOnOffHeader[] = $value;
      } else {
        $this->WriteOnOffHeader[$offset] = $value;
      }
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to unset
     * @return void
     */
    public function offsetUnset($offset)
    {
      unset($this->WriteOnOffHeader[$offset]);
    }

    /**
     * Iterator implementation
     *
     * @return WriteOnOffHeader Return the current element
     */
    public function current()
    {
      return current($this->WriteOnOffHeader);
    }

    /**
     * Iterator implementation
     * Move forward to next element
     *
     * @return void
     */
    public function next()
    {
      next($this->WriteOnOffHeader);
    }

    /**
     * Iterator implementation
     *
     * @return string|null Return the key of the current element or null
     */
    public function key()
    {
      return key($this->WriteOnOffHeader);
    }

    /**
     * Iterator implementation
     *
     * @return boolean Return the validity of the current position
     */
    public function valid()
    {
      return $this->key() !== null;
    }

    /**
     * Iterator implementation
     * Rewind the Iterator to the first element
     *
     * @return void
     */
    public function rewind()
    {
      reset($this->WriteOnOffHeader);
    }

    /**
     * Countable implementation
     *
     * @return WriteOnOffHeader Return count of elements
     */
    public function count()
    {
      return count($this->WriteOnOffHeader);
    }

}
