<?php

namespace Eurostop\Stocks;

class ArrayOfWriteOnOffDetail implements \ArrayAccess, \Iterator, \Countable
{

    /**
     * @var WriteOnOffDetail[] $WriteOnOffDetail
     */
    protected $WriteOnOffDetail = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return WriteOnOffDetail[]
     */
    public function getWriteOnOffDetail()
    {
      return $this->WriteOnOffDetail;
    }

    /**
     * @param WriteOnOffDetail[] $WriteOnOffDetail
     * @return \Eurostop\Stocks\ArrayOfWriteOnOffDetail
     */
    public function setWriteOnOffDetail(array $WriteOnOffDetail = null)
    {
      $this->WriteOnOffDetail = $WriteOnOffDetail;
      return $this;
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset An offset to check for
     * @return boolean true on success or false on failure
     */
    public function offsetExists($offset)
    {
      return isset($this->WriteOnOffDetail[$offset]);
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to retrieve
     * @return WriteOnOffDetail
     */
    public function offsetGet($offset)
    {
      return $this->WriteOnOffDetail[$offset];
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to assign the value to
     * @param WriteOnOffDetail $value The value to set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
      if (!isset($offset)) {
        $this->WriteOnOffDetail[] = $value;
      } else {
        $this->WriteOnOffDetail[$offset] = $value;
      }
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to unset
     * @return void
     */
    public function offsetUnset($offset)
    {
      unset($this->WriteOnOffDetail[$offset]);
    }

    /**
     * Iterator implementation
     *
     * @return WriteOnOffDetail Return the current element
     */
    public function current()
    {
      return current($this->WriteOnOffDetail);
    }

    /**
     * Iterator implementation
     * Move forward to next element
     *
     * @return void
     */
    public function next()
    {
      next($this->WriteOnOffDetail);
    }

    /**
     * Iterator implementation
     *
     * @return string|null Return the key of the current element or null
     */
    public function key()
    {
      return key($this->WriteOnOffDetail);
    }

    /**
     * Iterator implementation
     *
     * @return boolean Return the validity of the current position
     */
    public function valid()
    {
      return $this->key() !== null;
    }

    /**
     * Iterator implementation
     * Rewind the Iterator to the first element
     *
     * @return void
     */
    public function rewind()
    {
      reset($this->WriteOnOffDetail);
    }

    /**
     * Countable implementation
     *
     * @return WriteOnOffDetail Return count of elements
     */
    public function count()
    {
      return count($this->WriteOnOffDetail);
    }

}
