<?php

namespace Eurostop\Stocks;

class ArrayOfTransferDetail implements \ArrayAccess, \Iterator, \Countable
{

    /**
     * @var TransferDetail[] $TransferDetail
     */
    protected $TransferDetail = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return TransferDetail[]
     */
    public function getTransferDetail()
    {
      return $this->TransferDetail;
    }

    /**
     * @param TransferDetail[] $TransferDetail
     * @return \Eurostop\Stocks\ArrayOfTransferDetail
     */
    public function setTransferDetail(array $TransferDetail = null)
    {
      $this->TransferDetail = $TransferDetail;
      return $this;
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset An offset to check for
     * @return boolean true on success or false on failure
     */
    public function offsetExists($offset)
    {
      return isset($this->TransferDetail[$offset]);
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to retrieve
     * @return TransferDetail
     */
    public function offsetGet($offset)
    {
      return $this->TransferDetail[$offset];
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to assign the value to
     * @param TransferDetail $value The value to set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
      if (!isset($offset)) {
        $this->TransferDetail[] = $value;
      } else {
        $this->TransferDetail[$offset] = $value;
      }
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to unset
     * @return void
     */
    public function offsetUnset($offset)
    {
      unset($this->TransferDetail[$offset]);
    }

    /**
     * Iterator implementation
     *
     * @return TransferDetail Return the current element
     */
    public function current()
    {
      return current($this->TransferDetail);
    }

    /**
     * Iterator implementation
     * Move forward to next element
     *
     * @return void
     */
    public function next()
    {
      next($this->TransferDetail);
    }

    /**
     * Iterator implementation
     *
     * @return string|null Return the key of the current element or null
     */
    public function key()
    {
      return key($this->TransferDetail);
    }

    /**
     * Iterator implementation
     *
     * @return boolean Return the validity of the current position
     */
    public function valid()
    {
      return $this->key() !== null;
    }

    /**
     * Iterator implementation
     * Rewind the Iterator to the first element
     *
     * @return void
     */
    public function rewind()
    {
      reset($this->TransferDetail);
    }

    /**
     * Countable implementation
     *
     * @return TransferDetail Return count of elements
     */
    public function count()
    {
      return count($this->TransferDetail);
    }

}
