<?php

namespace Eurostop\Security;

class SecurityWebServiceInterfacePluginCustom2 extends \SoapClient
{

    /**
     * @var array $classmap The defined classes
     */
    private static $classmap = array (
      'DateTimeOffset' => 'Eurostop\\Security\\DateTimeOffsetCustom2',
      'AuthenticationResult' => 'Eurostop\\Security\\AuthenticationResultCustom2',
      'Login' => 'Eurostop\\Security\\LoginCustom2',
      'LoginResponse' => 'Eurostop\\Security\\LoginResponseCustom2',
      'RenewAuthToken' => 'Eurostop\\Security\\RenewAuthTokenCustom2',
      'RenewAuthTokenResponse' => 'Eurostop\\Security\\RenewAuthTokenResponseCustom2',
    );

    /**
     * @param array $options A array of config values
     * @param string $wsdl The wsdl file to use
     */
    public function __construct(array $options = array(), $wsdl = null)
    {
      foreach (self::$classmap as $key => $value) {
        if (!isset($options['classmap'][$key])) {
          $options['classmap'][$key] = $value;
        }
      }
      $options = array_merge(array (
      'features' => 1,
    ), $options);
      if (!$wsdl) {
        $wsdl = 'https://database-test.eurostop.jdsportscanada.com:9120/e-interface/security?wsdl';
      }
      parent::__construct($wsdl, $options);
    }

    /**
     * @param LoginCustom2 $parameters
     * @return LoginResponse
     */
    public function Login($parameters)
    {
      return $this->__soapCall('Login', array($parameters));
    }

    /**
     * @param RenewAuthTokenCustom2 $parameters
     * @return RenewAuthTokenResponse
     */
    public function RenewAuthToken($parameters)
    {
      return $this->__soapCall('RenewAuthToken', array($parameters));
    }

}
