<?php

namespace Eurostop\Sales;

class SerialisedVoucherNumber extends RetrievedDataItemOfSerialisedVoucherNumberDtonkuuQA70
{

    /**
     * @var string $BranchIdentifier
     */
    protected $BranchIdentifier = null;

    /**
     * @var string $ReservationToken
     */
    protected $ReservationToken = null;

    /**
     * @var int $TillNumber
     */
    protected $TillNumber = null;

    /**
     * @var string $VoucherNumber
     */
    protected $VoucherNumber = null;

    /**
     * @param int $TillNumber
     */
    public function __construct($TillNumber)
    {
      parent::__construct();
      $this->TillNumber = $TillNumber;
    }

    /**
     * @return string
     */
    public function getBranchIdentifier()
    {
      return $this->BranchIdentifier;
    }

    /**
     * @param string $BranchIdentifier
     * @return \Eurostop\Sales\SerialisedVoucherNumber
     */
    public function setBranchIdentifier($BranchIdentifier)
    {
      $this->BranchIdentifier = $BranchIdentifier;
      return $this;
    }

    /**
     * @return string
     */
    public function getReservationToken()
    {
      return $this->ReservationToken;
    }

    /**
     * @param string $ReservationToken
     * @return \Eurostop\Sales\SerialisedVoucherNumber
     */
    public function setReservationToken($ReservationToken)
    {
      $this->ReservationToken = $ReservationToken;
      return $this;
    }

    /**
     * @return int
     */
    public function getTillNumber()
    {
      return $this->TillNumber;
    }

    /**
     * @param int $TillNumber
     * @return \Eurostop\Sales\SerialisedVoucherNumber
     */
    public function setTillNumber($TillNumber)
    {
      $this->TillNumber = $TillNumber;
      return $this;
    }

    /**
     * @return string
     */
    public function getVoucherNumber()
    {
      return $this->VoucherNumber;
    }

    /**
     * @param string $VoucherNumber
     * @return \Eurostop\Sales\SerialisedVoucherNumber
     */
    public function setVoucherNumber($VoucherNumber)
    {
      $this->VoucherNumber = $VoucherNumber;
      return $this;
    }

}
