<?php

namespace Eurostop\Sales;

class ReceiptVoucherPurchaseCustom extends RetrievedDataItemOfReceiptVoucherPurchaseDtonkuuQA70Custom
{

    /**
     * @var float $VatValue
     */
    protected $VatValue = null;

    /**
     * @var string $VoucherNumber
     */
    protected $VoucherNumber = null;

    /**
     * @var ReceiptVoucherType $VoucherType
     */
    protected $VoucherType = null;

    /**
     * @var float $VoucherValue
     */
    protected $VoucherValue = null;

    /**
     * @param float $VatValue
     * @param ReceiptVoucherType $VoucherType
     * @param float $VoucherValue
     */
    public function __construct($VatValue, $VoucherType, $VoucherValue)
    {
      parent::__construct();
      $this->VatValue = $VatValue;
      $this->VoucherType = $VoucherType;
      $this->VoucherValue = $VoucherValue;
    }

    /**
     * @return float
     */
    public function getVatValue()
    {
      return $this->VatValue;
    }

    /**
     * @param float $VatValue
     * @return \Eurostop\Sales\ReceiptVoucherPurchase
     */
    public function setVatValue($VatValue)
    {
      $this->VatValue = $VatValue;
      return $this;
    }

    /**
     * @return string
     */
    public function getVoucherNumber()
    {
      return $this->VoucherNumber;
    }

    /**
     * @param string $VoucherNumber
     * @return \Eurostop\Sales\ReceiptVoucherPurchase
     */
    public function setVoucherNumber($VoucherNumber)
    {
      $this->VoucherNumber = $VoucherNumber;
      return $this;
    }

    /**
     * @return ReceiptVoucherType
     */
    public function getVoucherType()
    {
      return $this->VoucherType;
    }

    /**
     * @param ReceiptVoucherType $VoucherType
     * @return \Eurostop\Sales\ReceiptVoucherPurchase
     */
    public function setVoucherType($VoucherType)
    {
      $this->VoucherType = $VoucherType;
      return $this;
    }

    /**
     * @return float
     */
    public function getVoucherValue()
    {
      return $this->VoucherValue;
    }

    /**
     * @param float $VoucherValue
     * @return \Eurostop\Sales\ReceiptVoucherPurchase
     */
    public function setVoucherValue($VoucherValue)
    {
      $this->VoucherValue = $VoucherValue;
      return $this;
    }

}
