<?php

namespace Eurostop\Sales;

class ReceiptTaxCollection extends RetrievedDataItemOfReceiptTaxCollectionDtonkuuQA70
{

    /**
     * @var int $LineNumber
     */
    protected $LineNumber = null;

    /**
     * @var float $TaxableAmount
     */
    protected $TaxableAmount = null;

    /**
     * @var boolean $IsExempted
     */
    protected $IsExempted = null;

    /**
     * @var float $TaxAmountCollected
     */
    protected $TaxAmountCollected = null;

    /**
     * @var string $TaxRateIdentifier
     */
    protected $TaxRateIdentifier = null;

    /**
     * @param boolean $IsExempted
     * @param float $TaxAmountCollected
     */
    public function __construct($IsExempted, $TaxAmountCollected)
    {
      parent::__construct();
      $this->IsExempted = $IsExempted;
      $this->TaxAmountCollected = $TaxAmountCollected;
    }

    /**
     * @return int
     */
    public function getLineNumber()
    {
      return $this->LineNumber;
    }

    /**
     * @param int $LineNumber
     * @return \Eurostop\Sales\ReceiptTaxCollection
     */
    public function setLineNumber($LineNumber)
    {
      $this->LineNumber = $LineNumber;
      return $this;
    }

    /**
     * @return float
     */
    public function getTaxableAmount()
    {
      return $this->TaxableAmount;
    }

    /**
     * @param float $TaxableAmount
     * @return \Eurostop\Sales\ReceiptTaxCollection
     */
    public function setTaxableAmount($TaxableAmount)
    {
      $this->TaxableAmount = $TaxableAmount;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getIsExempted()
    {
      return $this->IsExempted;
    }

    /**
     * @param boolean $IsExempted
     * @return \Eurostop\Sales\ReceiptTaxCollection
     */
    public function setIsExempted($IsExempted)
    {
      $this->IsExempted = $IsExempted;
      return $this;
    }

    /**
     * @return float
     */
    public function getTaxAmountCollected()
    {
      return $this->TaxAmountCollected;
    }

    /**
     * @param float $TaxAmountCollected
     * @return \Eurostop\Sales\ReceiptTaxCollection
     */
    public function setTaxAmountCollected($TaxAmountCollected)
    {
      $this->TaxAmountCollected = $TaxAmountCollected;
      return $this;
    }

    /**
     * @return string
     */
    public function getTaxRateIdentifier()
    {
      return $this->TaxRateIdentifier;
    }

    /**
     * @param string $TaxRateIdentifier
     * @return \Eurostop\Sales\ReceiptTaxCollection
     */
    public function setTaxRateIdentifier($TaxRateIdentifier)
    {
      $this->TaxRateIdentifier = $TaxRateIdentifier;
      return $this;
    }

}
