<?php

namespace Eurostop\Sales;

class GetReceiptsByReceiptNumber
{

    /**
     * @var string $branchIdentifier
     */
    protected $branchIdentifier = null;

    /**
     * @var BranchIdentifierType $branchIdentifierType
     */
    protected $branchIdentifierType = null;

    /**
     * @var int $tillNumber
     */
    protected $tillNumber = null;

    /**
     * @var string $fromReceiptNumber
     */
    protected $fromReceiptNumber = null;

    /**
     * @var string $toReceiptNumber
     */
    protected $toReceiptNumber = null;

    /**
     * @var int $maxReceipts
     */
    protected $maxReceipts = null;

    /**
     * @param string $branchIdentifier
     * @param BranchIdentifierType $branchIdentifierType
     * @param int $tillNumber
     * @param string $fromReceiptNumber
     * @param string $toReceiptNumber
     * @param int $maxReceipts
     */
    public function __construct($branchIdentifier = null, $branchIdentifierType = null, $tillNumber = null, $fromReceiptNumber = null, $toReceiptNumber = null, $maxReceipts = null)
    {
      $this->branchIdentifier = $branchIdentifier;
      $this->branchIdentifierType = $branchIdentifierType;
      $this->tillNumber = $tillNumber;
      $this->fromReceiptNumber = $fromReceiptNumber;
      $this->toReceiptNumber = $toReceiptNumber;
      $this->maxReceipts = $maxReceipts;
    }

    /**
     * @return string
     */
    public function getBranchIdentifier()
    {
      return $this->branchIdentifier;
    }

    /**
     * @param string $branchIdentifier
     * @return \Eurostop\Sales\GetReceiptsByReceiptNumber
     */
    public function setBranchIdentifier($branchIdentifier)
    {
      $this->branchIdentifier = $branchIdentifier;
      return $this;
    }

    /**
     * @return BranchIdentifierType
     */
    public function getBranchIdentifierType()
    {
      return $this->branchIdentifierType;
    }

    /**
     * @param BranchIdentifierType $branchIdentifierType
     * @return \Eurostop\Sales\GetReceiptsByReceiptNumber
     */
    public function setBranchIdentifierType($branchIdentifierType)
    {
      $this->branchIdentifierType = $branchIdentifierType;
      return $this;
    }

    /**
     * @return int
     */
    public function getTillNumber()
    {
      return $this->tillNumber;
    }

    /**
     * @param int $tillNumber
     * @return \Eurostop\Sales\GetReceiptsByReceiptNumber
     */
    public function setTillNumber($tillNumber)
    {
      $this->tillNumber = $tillNumber;
      return $this;
    }

    /**
     * @return string
     */
    public function getFromReceiptNumber()
    {
      return $this->fromReceiptNumber;
    }

    /**
     * @param string $fromReceiptNumber
     * @return \Eurostop\Sales\GetReceiptsByReceiptNumber
     */
    public function setFromReceiptNumber($fromReceiptNumber)
    {
      $this->fromReceiptNumber = $fromReceiptNumber;
      return $this;
    }

    /**
     * @return string
     */
    public function getToReceiptNumber()
    {
      return $this->toReceiptNumber;
    }

    /**
     * @param string $toReceiptNumber
     * @return \Eurostop\Sales\GetReceiptsByReceiptNumber
     */
    public function setToReceiptNumber($toReceiptNumber)
    {
      $this->toReceiptNumber = $toReceiptNumber;
      return $this;
    }

    /**
     * @return int
     */
    public function getMaxReceipts()
    {
      return $this->maxReceipts;
    }

    /**
     * @param int $maxReceipts
     * @return \Eurostop\Sales\GetReceiptsByReceiptNumber
     */
    public function setMaxReceipts($maxReceipts)
    {
      $this->maxReceipts = $maxReceipts;
      return $this;
    }

}
