<?php

namespace Eurostop\Sales;

class GetReceiptsByReceiptId
{

    /**
     * @var int $fromReceiptId
     */
    protected $fromReceiptId = null;

    /**
     * @var int $toReceiptId
     */
    protected $toReceiptId = null;

    /**
     * @var int $maxReceipts
     */
    protected $maxReceipts = null;

    /**
     * @param int $fromReceiptId
     * @param int $toReceiptId
     * @param int $maxReceipts
     */
    public function __construct($fromReceiptId = null, $toReceiptId = null, $maxReceipts = null)
    {
      $this->fromReceiptId = $fromReceiptId;
      $this->toReceiptId = $toReceiptId;
      $this->maxReceipts = $maxReceipts;
    }

    /**
     * @return int
     */
    public function getFromReceiptId()
    {
      return $this->fromReceiptId;
    }

    /**
     * @param int $fromReceiptId
     * @return \Eurostop\Sales\GetReceiptsByReceiptId
     */
    public function setFromReceiptId($fromReceiptId)
    {
      $this->fromReceiptId = $fromReceiptId;
      return $this;
    }

    /**
     * @return int
     */
    public function getToReceiptId()
    {
      return $this->toReceiptId;
    }

    /**
     * @param int $toReceiptId
     * @return \Eurostop\Sales\GetReceiptsByReceiptId
     */
    public function setToReceiptId($toReceiptId)
    {
      $this->toReceiptId = $toReceiptId;
      return $this;
    }

    /**
     * @return int
     */
    public function getMaxReceipts()
    {
      return $this->maxReceipts;
    }

    /**
     * @param int $maxReceipts
     * @return \Eurostop\Sales\GetReceiptsByReceiptId
     */
    public function setMaxReceipts($maxReceipts)
    {
      $this->maxReceipts = $maxReceipts;
      return $this;
    }

}
